% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{is_root}
\alias{is_root}
\title{Test if taxa are roots}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object.}
}
\value{
A \code{logical} of length equal to the number of taxa.
}
\description{
Test if taxa are roots in a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object. Roots are taxa
without supertaxa, typically things like "Bacteria", or "Life".
\preformatted{
obj$is_root()
is_root(obj)}
}
\examples{
# Test for which taxon IDs correspond to roots
is_root(ex_taxmap)

# Filter out roots
filter_taxa(ex_taxmap, ! is_root)

}
\seealso{
Other taxonomy data functions: \code{\link{classifications}},
  \code{\link{id_classifications}},
  \code{\link{is_branch}}, \code{\link{is_internode}},
  \code{\link{is_leaf}}, \code{\link{is_stem}},
  \code{\link{map_data_}}, \code{\link{map_data}},
  \code{\link{n_leaves_1}}, \code{\link{n_leaves}},
  \code{\link{n_subtaxa_1}}, \code{\link{n_subtaxa}},
  \code{\link{n_supertaxa_1}}, \code{\link{n_supertaxa}},
  \code{\link{taxon_ids}}, \code{\link{taxon_indexes}},
  \code{\link{taxon_names}}, \code{\link{taxon_ranks}}
}
