% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_db.R
\name{taxon_db}
\alias{taxon_db}
\title{Taxon database class}
\usage{
taxon_db(db = character(), .names = NULL, ...)
}
\arguments{
\item{db}{Zero or more taxonomic database names. Should be a name contained in
\link{db_ref}. Inputs will be transformed to a \link{character} vector if possible.}

\item{.names}{The names of the vector.}

\item{...}{Additional arguments.}
}
\value{
An \code{S3} object of class \code{taxa_taxon_db}
}
\description{
\Sexpr[results=rd, stage=render]{taxa:::lifecycle("maturing")}
Used to store the names of taxon databases defined in \link{db_ref}. Primarily
used in other classes like \link{taxon_id} to define databases for each item.
}
\examples{

# Making new objects
x <- taxon_db(c('ncbi', 'ncbi', 'itis'))
x

# Manipulating objects
as.character(x)
x[2:3]
x[2:3] <- 'nbn'
names(x) <- c('a', 'b', 'c')
x['b']
x['b'] <- 'nbn'
x[x == 'itis'] <- 'gbif'

# Using as columns in tables
tibble::tibble(x = x, y = 1:3)
data.frame(x = x, y = 1:3)

# Converting to tables
tibble::as_tibble(x)
as_data_frame(x)

# Trying to use an invalid database generates an error
# x <- taxon_db(c('ncbi', 'ncbi', 'my_custom_db'))
# x[x == 'itis'] <- 'my_custom_db'

# Listing known databases and their properties
db_ref$get()

# Adding and using a new database
db_ref$set(name = 'my_custom_db', desc = 'I just made this up')
db_ref$get()
x <- taxon_db(c('ncbi', 'ncbi', 'my_custom_db'))

}
\seealso{
Other classes: 
\code{\link{[.taxa_classification}()},
\code{\link{classification}()},
\code{\link{taxon}()},
\code{\link{taxon_authority}()},
\code{\link{taxon_id}()},
\code{\link{taxon_rank}()}
}
\concept{classes}
