\name{gbif_parse}
\alias{gbif_parse}
\title{Parse taxon names using the GBIF name parser.}
\usage{
  gbif_parse(scientificname)
}
\arguments{
  \item{scientificname}{A character vector of scientific
  names.}
}
\value{
  A \code{data.frame} containing fields extracted from
  parsed taxon names. Fields returned are the union of
  fields extracted from all species names in
  \code{scientificname}.
}
\description{
  Parse taxon names using the GBIF name parser.
}
\examples{
\dontrun{
gbif_parse(scientificname='x Agropogon littoralis')
gbif_parse(c('Arrhenatherum elatius var. elatius',
             'Secale cereale subsp. cereale', 'Secale cereale ssp. cereale',
             'Vanessa atalanta (Linnaeus, 1758)'))
}
}
\author{
  John Baumgartner (johnbb@student.unimelb.edu.au)
}
\references{
  \url{http://dev.gbif.org/wiki/display/POR/Webservice+API},
  \url{http://tools.gbif.org/nameparser/api.do}
}
\seealso{
  \code{\link{gni_parse}}
}

