% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/comm2sci.R
\name{comm2sci}
\alias{comm2sci}
\title{Get scientific names from common names.}
\usage{
comm2sci(commnames, db = "eol", itisby = "search", simplify = TRUE, ...)
}
\arguments{
\item{commnames}{One or more common names or partial names.}

\item{db}{Data source, one of \emph{"eol"} (default), \emph{"itis"}, \emph{"tropicos"}
or \emph{"ncbi"}.}

\item{itisby}{Search for common names across entire names (search, default),
at beginning of names (begin), or at end of names (end).}

\item{simplify}{(logical) If TRUE, simplify output to a vector of names. If FALSE,
return variable formats from different sources, usually a data.frame.}

\item{...}{Further arguments passed on to internal methods.}
}
\value{
A vector of names.
}
\description{
Get scientific names from common names.
}
\examples{
\dontrun{
comm2sci(commnames='black bear')
comm2sci(commnames='black bear', db='itis')
comm2sci(commnames='annual blue grass', db='tropicos')
comm2sci(commnames=c('annual blue grass','tree of heaven'), db='tropicos')
comm2sci(commnames=c('black bear', 'roe deer'))

# Output easily converts to a data.frame with \\code{\\link[plyr]{ldply}}
library(plyr)
ldply(comm2sci(commnames=c('annual blue grass','tree of heaven'), db='tropicos'))
}
}
\author{
Scott Chamberlain (myrmecocystus@gmail.com)
}
\seealso{
\code{\link[taxize]{searchbycommonname}},
\code{\link[taxize]{searchbycommonnamebeginswith}},
\code{\link[taxize]{searchbycommonnameendswith}}, \code{\link[taxize]{eol_search}},
\code{\link[taxize]{tp_search}}

\code{\link[taxize]{sci2comm}}
}

