% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean}
\alias{clean}
\alias{clean,taxlist-method}
\title{Delete orphaned records}
\usage{
clean(object, ...)

\S4method{clean}{taxlist}(object, times = 2, ...)
}
\arguments{
\item{object}{A \linkS4class{taxlist} object.}

\item{...}{Further arguments passed from or to other methods.}

\item{times}{An integer indicating how many times the cleaning should be
repeated.}
}
\value{
A clean \linkS4class{taxlist} object.
}
\description{
Manipulation of slots may generate orphaned entries in
\linkS4class{taxlist} objects.
The function \code{clean} deletes such entries and restores the consistency
of the objects.
}
\details{
Cleaning of objects will follow the deletion of orphaned names, orphaned
taxon trait entries, and orphaned parent entries.
}
\examples{
## Direct manipulation of slot taxonRelations generates an invalid object
Easplist@taxonRelations <- Easplist@taxonRelations[1:5, ]
\dontrun{
summary(Easplist)
}	

## Now apply cleaning
Easplist <- clean(Easplist)
summary(Easplist)

}
\author{
Miguel Alvarez.
}
