% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_methods.R
\name{load_taxonomies}
\alias{load_taxonomies}
\title{Load and merge GBIF and NCBI taxonomic data}
\usage{
load_taxonomies(GBIF_path, NCBI_path)
}
\arguments{
\item{GBIF_path}{Path to the GBIF backbone taxonomy (compressed or uncompressed).}

\item{NCBI_path}{Path to the NCBI taxonomy (compressed or uncompressed).}
}
\value{
A tibble containing merged GBIF and NCBI taxonomic data.
}
\description{
\code{load_taxonomies()} parses and merges a GBIF \code{Taxon.tsv} file (available
within the \url{https://hosted-datasets.gbif.org/datasets/backbone/current/backbone.zip} archive) and
a Taxonkit (\url{https://bioinf.shenwei.me/taxonkit/download/}) output file obtained by running: \verb{taxonkit list --ids 1 | taxonkit lineage --show-lineage-taxids --show-lineage-ranks --show-rank --show-name > All.lineages.tsv}.
}
\examples{
\dontrun{load_taxonomies("path/to/GBIF/Taxon.tsv","path/to/NCBI-Taxonkit/All.lineages.tsv")}
}
