% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange.R
\name{arrange_data}
\alias{arrange_data}
\title{Arrange rows}
\usage{
arrange_data(.data, ...)
}
\arguments{
\item{.data}{data frame}

\item{...}{One or more unquoted names of columns on which to arrange the rows. If none
are supplied, the data are returned as is. By default, ordering is done in ascending
order. To orer in descending order, use \code{\link{decr}} on desired variable(s).}
}
\value{
Rearranged data frame
}
\description{
Arrange rows via descending or ascending column values
}
\examples{

## data frame to arrange
dat <- data.frame(
  a = c(rep("a", 3), rep("b", 3), rep("c", 4)),
  b = c( 3, 3, 2,     8, 8, 1,     5,  5, 5, 9),
  c = c(-1, 0, 0,    -5, 0, 2,    -2, -4, 1, 0),
  stringsAsFactors = FALSE
)

## arrange by one column
arrange_data(dat, a)

## arrange by multiple columns
arrange_data(dat, decr(a), b, c)

}
