% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplPlotPlate.R
\name{tcplPlotPlate}
\alias{tcplPlotPlate}
\title{Plot plate heatmap}
\usage{
tcplPlotPlate(dat, apid, id = NULL, quant = c(0.001, 0.999))
}
\arguments{
\item{dat}{data.table containing tcpl data}

\item{apid}{Character of length 1, the apid to plot}

\item{id}{Integer of length 1, the assay component id (acid) or assay
endpoint id (aeid), depending on level. Only need to specify for multiplexed
assays when more than one acid/aeid share an apid.}

\item{quant}{Numeric vector, the range of data to include in the legend}
}
\description{
\code{tcplPlotPlate} generates a heatmap of assay plate data
}
\details{
The legend represents the range of the data supplied to dat, for the 
applicable ID. The additional horizontal lines on the legend indicate the
range of the plotted plate, to show the relation of the plate to the assay
as a whole. A plot with a legend specific for the given apid can be created
by only supplying the data for the apid of interest to 'dat'.

The quant parameter, by default including 99.8% of the data, 
allows for extreme outliers without losing resolution. Outliers in either
direction will be highlighted with a dark ring, as seen in the example. 
A NULL value for 'quant' will not restrict the data at all, and will use 
the full range for the legend. 

Wells with a well quality of 0 (only applicable for level 1 plots), will 
have an "X" through their center.
}
\note{
For the optimal output size, use width = 10, height = 10*(2/3), 
pointsize = 10, units = "in"
}
\examples{
## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- tcplConfList()
tcplConfDefault()
 
d1 <- tcplLoadData(lvl = 1, fld = "acid", val = 1)
\dontrun{
tcplPlotPlate(dat = d1, apid = "09Apr2014.Plate.17")
}

## Reset configuration
options(conf_store)
 
}
