% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hitcont.R
\name{hitcont}
\alias{hitcont}
\title{Continuous Hitcalls}
\usage{
hitcont(indf, xs = NULL, ys = NULL, newcutoff, mc.cores = 1)
}
\arguments{
\item{indf}{Dataframe similar to concRespCore input. Must contain "conc" and "resp"
columns if xs and ys are not provided. Must contain "top", "ac50", "er",
"fit_method", "caikwt", and "mll" columns as well as columns for each
model parameter.}

\item{xs}{List of concentration vectors that can be provided for speed.}

\item{ys}{List of response vectors that can be provided for speed.}

\item{newcutoff}{Vector of new cutoff values to use. Length should be equal
to rows in indf.}

\item{mc.cores}{Number of cores to use for large dataframes.}
}
\value{
Vector of hitcalls between 0 and 1 with length equal to indf row
  number.
}
\description{
Wrapper that computes continuous hitcalls for a provided concRespCore input row.
}
\details{
indf parameter columns should be NA when not required by fit method. "conc"
and "resp" entries should be a single string with values separated by |.
Details on indf columns can be found in concRespCore.
}
