% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hitloginner.R
\name{hitloginner}
\alias{hitloginner}
\title{Hit Logic Inner (Discrete)}
\usage{
hitloginner(conc = NULL, resp, top, cutoff, ac50 = NULL)
}
\arguments{
\item{conc}{Vector of concentrations (No longer necessary).}

\item{resp}{Vector of responses.}

\item{top}{Model top.}

\item{cutoff}{Desired cutoff.}

\item{ac50}{Model AC50 (No longer necessary).}
}
\value{
Outputs 1 for hit, 0 for miss.
}
\description{
Contains hit logic, called directly during CR fitting or later through "hitlogic".
}
\details{
The purpose of this function is to keep the actual hit rules in one
location so it can be called during CR fitting, and then again after the fact
for a variety of cutoffs. Curves fit with constant winning should have
top = NA, generating a miss.
}
\examples{
hitloginner(resp = 1:8, top = 7, cutoff = 5) #hit
hitloginner(resp = 1:8, top = 7, cutoff = 7.5) #miss: top too low
hitloginner(resp = 1:8, top = 9, cutoff = 8.5) #miss: no response> cutoff
hitloginner(resp = 1:8, top = NA, cutoff = 5) #miss: no top (constant)
}
