% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qenv-get_warnings.R
\name{get_warnings}
\alias{get_warnings}
\alias{get_warnings,qenv-method}
\alias{get_warnings,qenv.error-method}
\alias{get_warnings,NULL-method}
\title{Get warnings from \code{qenv} object}
\usage{
get_warnings(object)
}
\arguments{
\item{object}{(\code{qenv})}
}
\value{
\code{character} containing warning information or \code{NULL} if no warnings.
}
\description{
Retrieve all warnings raised during code evaluation in a \code{qenv}.
}
\examples{
data_q <- qenv()
data_q <- eval_code(data_q, "iris_data <- iris")
warning_qenv <- eval_code(
  data_q,
  bquote(p <- hist(iris_data[, .("Sepal.Length")], ff = ""))
)
cat(get_warnings(warning_qenv))

}
