% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prepare_arm_levels}
\alias{prepare_arm_levels}
\title{Expression: Prepare Arm Levels}
\usage{
prepare_arm_levels(dataname, parentname, arm_var, drop_arm_levels = TRUE)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{drop_arm_levels}{(\code{logical})\cr whether to drop unused levels of \code{arm_var}. If \code{TRUE}, \code{arm_var} levels are
set to those used in the \code{dataname} dataset. If \code{FALSE}, \code{arm_var} levels are set to those used in the
\code{parentname} dataset. If \code{dataname} and \code{parentname} are the same, then \code{drop_arm_levels} is set to \code{TRUE} and
user input for this parameter is ignored.}
}
\value{
a \verb{\{} object. See \code{\link[base:Paren]{base::Paren()}} for details.
}
\description{
This function generates the standard expression for pre-processing of dataset
arm levels in and is used to apply the same steps in safety teal modules.
}
\examples{
prepare_arm_levels(
  dataname = "adae",
  parentname = "adsl",
  arm_var = "ARMCD",
  drop_arm_levels = TRUE
)

prepare_arm_levels(
  dataname = "adae",
  parentname = "adsl",
  arm_var = "ARMCD",
  drop_arm_levels = FALSE
)

}
