% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_pp_patient_timeline.R
\name{tm_g_pp_patient_timeline}
\alias{tm_g_pp_patient_timeline}
\title{teal Module: Patient Profile Timeline Plot}
\usage{
tm_g_pp_patient_timeline(
  label,
  dataname_adcm = "ADCM",
  dataname_adae = "ADAE",
  parentname = "ADSL",
  patient_col = "USUBJID",
  aeterm = NULL,
  cmdecod = NULL,
  aetime_start = NULL,
  aetime_end = NULL,
  dstime_start = NULL,
  dstime_end = NULL,
  aerelday_start = NULL,
  aerelday_end = NULL,
  dsrelday_start = NULL,
  dsrelday_end = NULL,
  font_size = c(12L, 12L, 25L),
  plot_height = c(700L, 200L, 2000L),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL,
  ggplot2_args = teal.widgets::ggplot2_args()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname_adcm}{(\code{character})\cr name of \code{ADCM} dataset or equivalent.}

\item{dataname_adae}{(\code{character})\cr name of \code{ADAE} dataset or equivalent.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{patient_col}{(\code{character})\cr name of patient ID variable.}

\item{aeterm}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{AETERM} variable from \code{dataname}.}

\item{cmdecod}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMDECOD} variable from \code{dataname_adcm}.}

\item{aetime_start}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and preselected option for the \code{ASTDTM} variable from \code{dataname_adae}.}

\item{aetime_end}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{AENDTM} variable from \code{dataname_adae}.}

\item{dstime_start}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and preselected option for the \code{CMASTDTM} variable from \code{dataname_adcm}.}

\item{dstime_end}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMAENDTM} variable from \code{dataname_adcm}.}

\item{aerelday_start}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and preselected option for the \code{ASTDY} variable from \code{dataname_adae}.}

\item{aerelday_end}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and preselected option for the \code{AENDY} variable from \code{dataname_adae}.}

\item{dsrelday_start}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and preselected option for the \code{ASTDY} variable from \code{dataname_adcm}.}

\item{dsrelday_end}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and preselected option for the \code{AENDY} variable from \code{dataname_adcm}.}

\item{font_size}{(\code{numeric})\cr numeric vector of length 3 of current, minimum and maximum font size values.}

\item{plot_height}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a patient profile timeline \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} type plot using ADaM datasets.
}
\examples{
library(nestcolor)
library(dplyr)

data <- teal_data()
data <- within(data, {
  ADAE <- tmc_ex_adae
  ADSL <- tmc_ex_adsl \%>\% filter(USUBJID \%in\% ADAE$USUBJID)
  ADCM <- tmc_ex_adcm \%>\% mutate(
    CMSTDY = case_when(
      CMCAT == "medcl B" ~ 20,
      CMCAT == "medcl C" ~ 150,
      TRUE ~ 1
    ) \%>\% with_label("Study Day of Start of Medication"),
    CMENDY = case_when(
      CMCAT == "medcl B" ~ 700,
      CMCAT == "medcl C" ~ 1000,
      TRUE ~ 500
    ) \%>\% with_label("Study Day of End of Medication"),
    CMASTDTM = ASTDTM,
    CMAENDTM = AENDTM
  )
})

adcm_keys <- c("STUDYID", "USUBJID", "ASTDTM", "CMSEQ", "ATC1", "ATC2", "ATC3", "ATC4")
datanames(data) <- c("ADSL", "ADAE", "ADCM")
join_keys(data) <- default_cdisc_join_keys[c("ADSL", "ADAE", "ADCM")]
join_keys(data)["ADCM", "ADCM"] <- adcm_keys
join_keys(data)["ADAE", "ADCM"] <- c("STUDYID", "USUBJID")

app <- init(
  data = data,
  modules = modules(
    tm_g_pp_patient_timeline(
      label = "Patient Timeline",
      dataname_adae = "ADAE",
      dataname_adcm = "ADCM",
      parentname = "ADSL",
      patient_col = "USUBJID",
      plot_height = c(600L, 200L, 2000L),
      cmdecod = choices_selected(
        choices = variable_choices(data[["ADCM"]], "CMDECOD"),
        selected = "CMDECOD",
      ),
      aeterm = choices_selected(
        choices = variable_choices(data[["ADAE"]], "AETERM"),
        selected = c("AETERM")
      ),
      aetime_start = choices_selected(
        choices = variable_choices(data[["ADAE"]], "ASTDTM"),
        selected = c("ASTDTM")
      ),
      aetime_end = choices_selected(
        choices = variable_choices(data[["ADAE"]], "AENDTM"),
        selected = c("AENDTM")
      ),
      dstime_start = choices_selected(
        choices = variable_choices(data[["ADCM"]], "CMASTDTM"),
        selected = c("CMASTDTM")
      ),
      dstime_end = choices_selected(
        choices = variable_choices(data[["ADCM"]], "CMAENDTM"),
        selected = c("CMAENDTM")
      ),
      aerelday_start = choices_selected(
        choices = variable_choices(data[["ADAE"]], "ASTDY"),
        selected = c("ASTDY")
      ),
      aerelday_end = choices_selected(
        choices = variable_choices(data[["ADAE"]], "AENDY"),
        selected = c("AENDY")
      ),
      dsrelday_start = choices_selected(
        choices = variable_choices(data[["ADCM"]], "ASTDY"),
        selected = c("ASTDY")
      ),
      dsrelday_end = choices_selected(
        choices = variable_choices(data[["ADCM"]], "AENDY"),
        selected = c("AENDY")
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
