% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_front_page.R
\name{tm_front_page}
\alias{tm_front_page}
\title{\code{teal} module: Front page}
\usage{
tm_front_page(
  label = "Front page",
  header_text = character(0),
  tables = list(),
  additional_tags = tagList(),
  footnotes = character(0),
  show_metadata = FALSE
)
}
\arguments{
\item{label}{(\code{character(1)}) Label shown in the navigation item for the module or module group.
For \code{modules()} defaults to \code{"root"}. See \code{Details}.}

\item{header_text}{(\code{character} vector) text to be shown at the top of the module, for each
element, if named the name is shown first in bold as a header followed by the value. The first
element's header is displayed larger than the others.}

\item{tables}{(\verb{named list} of \code{data.frame}s) tables to be shown in the module.}

\item{additional_tags}{(\code{shiny.tag.list} or \code{html}) additional \code{shiny} tags or \code{html} to be included after the table,
for example to include an image, \code{tagList(tags$img(src = "image.png"))} or to include further \code{html},
\code{HTML("html text here")}.}

\item{footnotes}{(\code{character} vector) of text to be shown at the bottom of the module, for each
element, if named the name is shown first in bold, followed by the value.}

\item{show_metadata}{(\code{logical}) indicating whether the metadata of the datasets be available on the module.}
}
\value{
Object of class \code{teal_module} to be used in \code{teal} applications.
}
\description{
Creates a simple front page for \code{teal} applications, displaying
introductory text, tables, additional \code{html} or \code{shiny} tags, and footnotes.
}
\examples{
data <- teal_data()
data <- within(data, {
  require(nestcolor)
  ADSL <- rADSL
  attr(ADSL, "metadata") <- list("Author" = "NEST team", "data_source" = "synthetic data")
})
datanames(data) <- "ADSL"
join_keys(data) <- default_cdisc_join_keys[datanames(data)]

table_1 <- data.frame(Info = c("A", "B"), Text = c("A", "B"))
table_2 <- data.frame(`Column 1` = c("C", "D"), `Column 2` = c(5.5, 6.6), `Column 3` = c("A", "B"))
table_3 <- data.frame(Info = c("E", "F"), Text = c("G", "H"))

table_input <- list(
  "Table 1" = table_1,
  "Table 2" = table_2,
  "Table 3" = table_3
)

app <- init(
  data = data,
  modules = modules(
    tm_front_page(
      header_text = c(
        "Important information" = "It can go here.",
        "Other information" = "Can go here."
      ),
      tables = table_input,
      additional_tags = HTML("Additional HTML or shiny tags go here <br>"),
      footnotes = c("X" = "is the first footnote", "Y is the second footnote"),
      show_metadata = TRUE
    )
  ),
  header = tags$h1("Sample Application"),
  footer = tags$p("Application footer"),
)

if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
