# teal.modules.general

<!-- start badges -->
[![CRAN Version](https://www.r-pkg.org/badges/version/teal.modules.general?color=green)](https://cran.r-project.org/package=teal.modules.general)
[![Total Downloads](http://cranlogs.r-pkg.org/badges/grand-total/teal.modules.general?color=green)](https://cran.r-project.org/package=teal.modules.general)
[![Last Month Downloads](http://cranlogs.r-pkg.org/badges/last-month/teal.modules.general?color=green)](https://cran.r-project.org/package=teal.modules.general)
[![Last Week Downloads](http://cranlogs.r-pkg.org/badges/last-week/teal.modules.general?color=green)](https://cran.r-project.org/package=teal.modules.general)

[![Check 🛠](https://github.com/insightsengineering/teal.modules.general/actions/workflows/check.yaml/badge.svg)](https://insightsengineering.github.io/teal.modules.general/main/unit-test-report/)
[![Docs 📚](https://github.com/insightsengineering/teal.modules.general/actions/workflows/docs.yaml/badge.svg)](https://insightsengineering.github.io/teal.modules.general/)
[![Code Coverage 📔](https://raw.githubusercontent.com/insightsengineering/teal.modules.general/_xml_coverage_reports/data/main/badge.svg)](https://insightsengineering.github.io/teal.modules.general/main/coverage-report/)

![GitHub forks](https://img.shields.io/github/forks/insightsengineering/teal.modules.general?style=social)
![GitHub repo stars](https://img.shields.io/github/stars/insightsengineering/teal.modules.general?style=social)

![GitHub commit activity](https://img.shields.io/github/commit-activity/m/insightsengineering/teal.modules.general)
![GitHub contributors](https://img.shields.io/github/contributors/insightsengineering/teal.modules.general)
![GitHub last commit](https://img.shields.io/github/last-commit/insightsengineering/teal.modules.general)
![GitHub pull requests](https://img.shields.io/github/issues-pr/insightsengineering/teal.modules.general)
![GitHub repo size](https://img.shields.io/github/repo-size/insightsengineering/teal.modules.general)
![GitHub language count](https://img.shields.io/github/languages/count/insightsengineering/teal.modules.general)
[![Project Status: Active – The project has reached a stable, usable state and is being actively developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![Current Version](https://img.shields.io/github/r-package/v/insightsengineering/teal.modules.general/main?color=purple\&label=package%20version)](https://github.com/insightsengineering/teal.modules.general/tree/main)
[![Open Issues](https://img.shields.io/github/issues-raw/insightsengineering/teal.modules.general?color=red\&label=open%20issues)](https://github.com/insightsengineering/teal.modules.general/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc)
<!-- end badges -->

This package contains a set of standard `teal` modules for you to include in applications.
These include modules for:

<!-- markdownlint-disable MD007 MD030 -->
-   viewing data (including `tm_variable_browser`, `tm_data_table`, `tm_file_viewer`, ...)
-   visualizing data (`tm_g_scatterplot`, `tm_g_association`, ...)
-   understanding missing and outlier values within your data (`tm_missing_data`, `tm_outliers`, ...)
-   performing simple data analysis (`tm_a_pca`, `tm_g_distribution`, `tm_a_regression`, ...).
<!-- markdownlint-enable MD007 MD030 -->

These modules work with `CDISC` data, independent datasets and general relational data.

Please see [`teal` gallery](https://github.com/insightsengineering/teal.gallery) and [TLG Catalog](https://github.com/insightsengineering/tlg-catalog) to see examples of `teal` apps with modules from this package.

## Installation

```r
install.packages('teal.modules.general')
```

Alternatively, you might want to use the development version.

```r
# install.packages("pak")
pak::pak("insightsengineering/teal.modules.general")
```

## Usage

To understand how to use this package, please refer to the [Getting Started](https://insightsengineering.github.io/teal.modules.general/latest-tag/articles/teal-modules-general.html) article, which provides multiple examples of code implementation.

## Playground

You can try out the package without installing it in the Shinylive:

* [stable](https://shinylive.io/r/editor/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMAcwpxm1AJQAdCGAC+AXSA)
* [development](https://shinylive.io/r/editor/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMI1UgSxIGcAKAdzgCMAnAfVQGsA5jy5xURRgAIAvJILMAOmC4BaAK4Q6ANzhdGcJTMlKAFqVKpGiAPTXUJqFxhQdeuBlUbtu-RgAmcFpKuJKCcKQA8rQMEIpg7Nx8QiJiEkoAlJkKEAA2dNyOAJ7M5FA5GDBEfmo5cIwYYRC6ZenZYAC+ALpAA)

## Getting help

If you encounter a bug or have a feature request, please file an issue. For questions, discussions, and staying up to date, please use the `teal` channel in the [`pharmaverse` slack workspace](https://pharmaverse.slack.com).

## Acknowledgment

This package is a result of a joint efforts by many developers and stakeholders. We would like to thank everyone who contributed so far!

[![Stargazers repo roster for @insightsengineering/teal.modules.general](https://reporoster.com/stars/insightsengineering/teal.modules.general)](https://github.com/insightsengineering/teal.modules.general/stargazers)
[![Forkers repo roster for @insightsengineering/teal.modules.general](https://reporoster.com/forks/insightsengineering/teal.modules.general)](https://github.com/insightsengineering/teal.modules.general/network/members)

## Stargazers over time

[![Stargazers over time](https://starchart.cc/insightsengineering/teal.modules.general.svg)](https://starchart.cc/insightsengineering/teal.modules.general)
