% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Archiver.R
\docType{class}
\name{FileArchiver}
\alias{FileArchiver}
\title{\code{FileArchiver}: A File-based \code{Archiver}}
\description{
Inherits from \code{Archiver} to provide file-based archiving functionality.
Manages an output directory for storing archived data.
}
\examples{

## ------------------------------------------------
## Method `FileArchiver$new`
## ------------------------------------------------

FileArchiver <- getFromNamespace("FileArchiver", "teal.reporter")
FileArchiver$new()

## ------------------------------------------------
## Method `FileArchiver$get_output_dir`
## ------------------------------------------------

FileArchiver <- getFromNamespace("FileArchiver", "teal.reporter")
FileArchiver$new()$get_output_dir()
}
\keyword{internal}
\section{Super class}{
\code{\link[teal.reporter:Archiver]{teal.reporter::Archiver}} -> \code{FileArchiver}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FileArchiver-new}{\code{FileArchiver$new()}}
\item \href{#method-FileArchiver-finalize}{\code{FileArchiver$finalize()}}
\item \href{#method-FileArchiver-get_output_dir}{\code{FileArchiver$get_output_dir()}}
\item \href{#method-FileArchiver-clone}{\code{FileArchiver$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="Archiver" data-id="read"><a href='../../teal.reporter/html/Archiver.html#method-Archiver-read'><code>teal.reporter::Archiver$read()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="Archiver" data-id="write"><a href='../../teal.reporter/html/Archiver.html#method-Archiver-write'><code>teal.reporter::Archiver$write()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileArchiver-new"></a>}}
\if{latex}{\out{\hypertarget{method-FileArchiver-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{FileArchiver} object with a unique output directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileArchiver$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Object of class \code{FileArchiver}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{FileArchiver <- getFromNamespace("FileArchiver", "teal.reporter")
FileArchiver$new()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileArchiver-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-FileArchiver-finalize}{}}}
\subsection{Method \code{finalize()}}{
Finalizes a \code{FileArchiver} object.
Cleans up by removing the output directory and its contents.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileArchiver$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileArchiver-get_output_dir"></a>}}
\if{latex}{\out{\hypertarget{method-FileArchiver-get_output_dir}{}}}
\subsection{Method \code{get_output_dir()}}{
Get \code{output_dir} field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileArchiver$get_output_dir()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character} a \code{output_dir} field path.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{FileArchiver <- getFromNamespace("FileArchiver", "teal.reporter")
FileArchiver$new()$get_output_dir()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileArchiver-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FileArchiver-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileArchiver$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
