% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tleaves.R
\name{.get_hvap}
\alias{.get_hvap}
\title{h_vap: heat of vaporization (J / mol)}
\usage{
.get_hvap(T_leaf, unitless)
}
\arguments{
\item{T_leaf}{Leaf temperature in Kelvin}

\item{unitless}{Logical. Should function use parameters with \code{units}? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}
}
\value{
Value in J/mol of class \code{units}
}
\description{
h_vap: heat of vaporization (J / mol)
}
\details{
\bold{Heat of vaporization:} The heat of vaporization (\eqn{h_\mathrm{vap}}{h_vap}) is a function of temperature. I used data from on temperature and \eqn{h_\mathrm{vap}}{h_vap} from Nobel (2009, Appendix 1) to estimate a linear regression. See Examples.
}
\examples{

# Heat of vaporization and temperature
## data from Nobel (2009)

T_K <- 273.15 + c(0, 10, 20, 25, 30, 40, 50, 60)
h_vap <- 1e3 * c(45.06, 44.63, 44.21, 44.00, 
                 43.78, 43.35, 42.91, 42.47) # (in J / mol)
                 
fit <- lm(h_vap ~ T_K)

## coefficients are 56847.68250 J / mol and 43.12514 J / (mol K)

coef(fit) 

T_leaf <- 298.15
h_vap <- set_units(56847.68250, J / mol) - 
           set_units(43.12514, J / mol / K) * set_units(T_leaf, K)

## h_vap at 298.15 K is 43989.92 [J/mol]

set_units(h_vap, J / mol)

tealeaves:::.get_hvap(set_units(298.15, K), FALSE)

}
\references{
Nobel PS. 2009. Physicochemical and Environmental Plant Physiology. 4th Edition. Academic Press.
}
