% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{vm_qqplot}
\alias{vm_qqplot}
\title{von Mises Quantile-Quantile Plot}
\usage{
vm_qqplot(
  x,
  w = NULL,
  axial = TRUE,
  mean = NULL,
  kappa = NULL,
  xlab = "von Mises quantile function",
  ylab = "Empirical quantile function",
  main = "von Mises Q-Q Plot",
  ...
)
}
\arguments{
\item{x}{numeric. Angles in degrees}

\item{w}{numeric. optional weightings for \code{x} to estimate \code{mean} and \code{kappa}.}

\item{axial}{Logical. Whether data are uniaxial (\code{axial=FALSE})}

\item{mean}{numeric. Circular mean of the von Mises distribution. If \code{NULL},
it will be estimated from \code{x}.}

\item{kappa}{numeric. Concentration parameter of the von Mises distribution.
If \code{NULL}, it will be estimated from \code{x}.}

\item{xlab, ylab, main}{plot labels.}

\item{...}{graphical parameters}
}
\value{
plot
}
\description{
Produces a Q-Q plot of the data against a specified von Mises distribution
to graphically assess the goodness of fit of the model.
}
\examples{
x_vm <- rvm(100, mean = 0, kappa = 4)
vm_qqplot(x_vm, axial = FALSE, pch = 20)

x_unif <- runif(100, 0, 360)
vm_qqplot(x_unif, axial = FALSE, pch = 20)
}
