% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.stFit.R
\name{plot.stFit}
\alias{plot.stFit}
\title{Plot stFit objects}
\usage{
\method{plot}{stFit}(x, type = "density", stData = NULL,
  coord.s = NULL, coord.knot = NULL, text.size = NULL,
  axis.text.size = NULL, title.text.size = NULL, burn = 1,
  signif.telecon = F, p = 1, local.covariate = NULL, lwd = NULL,
  facet.signif = 3, stat.smooth.bw = NULL, stat.smooth.degree = NULL,
  dots = NULL, ...)
}
\arguments{
\item{x}{Object of class stFit to plot.}

\item{type}{One of the following options to specify what type of plot to build
\describe{
  \item{traceplot}{  }
  \item{density}{  }
  \item{pairs}{  }
  \item{teleconnection}{  }
  \item{teleconnection_local}{  }
  \item{teleconnection_knot}{  }
  \item{teleconnection_knot_transect}{  }
  \item{teleconnection_knot_influence}{  }
  \item{beta}{ }
}}

\item{stData}{Object of class stData to provide coordinate and related
information for plotting estimated teleconnection effects}

\item{coord.s}{if plot type is 'teleconnection', specifies the longitude and 
latitude of local coordinate for which to plot estimated teleconnection 
effects. if NULL, the middle local coordinate will be plotted.}

\item{coord.knot}{if plot type is 'teleconnection_knot_influence' or 
'teleconnection_knot_local', 
 specifies the longitude and latitude of knot coordinate 
 for which to plot influence of remote coefficient on remote covariates, or
 the teleconnection coefficients associated with coord.knot}

\item{text.size}{number specifying the size of text labels}

\item{axis.text.size}{number specifying the size of axis text labels}

\item{title.text.size}{number specifying the size of title}

\item{burn}{number of observations to exclude from graph}

\item{signif.telecon}{if TRUE, will highlight significant teleconnection
effects when type=='teleconnection'}

\item{p}{If stFit was fit with spatially varying coefficients, p specifies 
the index of the spatially varying coefficient to plot}

\item{local.covariate}{data.frame with variables, 'lon.Y', 'lat.Y', 'x'
that will be plotted against teleconnection effects if 
type=='teleconnection_knot_transect'}

\item{lwd}{specifies linewidth for plots that include reference lines}

\item{facet.signif}{number of significant figures to round facet latitudes 
and longitudes for if type=='teleconnection_knot_transect'}

\item{stat.smooth.bw}{if type=='teleconnection_knot_transect' this specifies
the bandwith of the non-parametric smooth of the estimates}

\item{stat.smooth.degree}{if type=='teleconnection_knot_transect' this 
specifies the degree of the non-parametric smooth of the estimates}

\item{dots}{additional named arguments with defaults to pass to additional 
functions}

\item{...}{additional arguments to pass to functions}
}
\value{
a ggplot object with the specified map
}
\description{
This function provides basic plotting for telefit package data.
}
\examples{

data("coprecip.fit")
plot(coprecip.fit, burn = 50, type = 'trace')

}
