% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bot.R
\name{sendLocation}
\alias{sendLocation}
\title{Send point on the map}
\usage{
sendLocation(
  chat_id,
  latitude,
  longitude,
  disable_notification = FALSE,
  reply_to_message_id = NULL,
  reply_markup = NULL
)
}
\arguments{
\item{chat_id}{Unique identifier for the target chat or username of
the target channel.}

\item{latitude}{Latitude of location.}

\item{longitude}{Longitude of location.}

\item{disable_notification}{(Optional). Sends the message silently. Users
will receive a notification with no sound.}

\item{reply_to_message_id}{(Optional). If the message is a reply, ID of the
original message.}

\item{reply_markup}{(Optional). A Reply Markup parameter object, it can be
either:
\itemize{
 \item{\code{\link{ReplyKeyboardMarkup}}}
 \item{\code{\link{InlineKeyboardMarkup}}}
 \item{\code{\link{ReplyKeyboardRemove}}}
 \item{\code{\link{ForceReply}}}}}
}
\description{
Use this method to send point on the map.
}
\details{
You can also use it's snake_case equivalent \code{send_location}.
}
\examples{
\dontrun{
bot <- Bot(token = bot_token("RTelegramBot"))
chat_id <- user_id("Me")

bot$sendLocation(
  chat_id = chat_id,
  latitude = 51.521727,
  longitude = -0.117255
)
}
}
