% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionals.R
\name{optionals}
\alias{optionals}
\alias{optionals.character}
\alias{optionals.list}
\alias{optionals.t2d_opt}
\alias{print.t2d_opt}
\alias{print.t2d_opt_LINES}
\title{Optional input files}
\usage{
optionals(x, fname, ...)

\method{optionals}{character}(x, fname, ...)

\method{optionals}{list}(x, fname, ...)

\method{optionals}{t2d_opt}(x, fname, ..., vals)

\method{print}{t2d_opt}(x, ..., n = 10)

\method{print}{t2d_opt_LINES}(x, ..., n = 10)
}
\arguments{
\item{x}{Either:
a \code{character} vector where each element represents a line of content for
the optional input file;
a \code{list} with multiple \code{character} vectors to provide the contents
for multiple optional files;
an object of type \code{t2d_opt} to add further optional file(s).}

\item{fname}{\code{character}, file name(s).}

\item{...}{Arguments passed to or from other methods.}

\item{vals}{If \code{x} is a \code{t2d_opt} object: a \code{character} vector
or a \code{list} with the values for the additional optional input file(s).}

\item{n}{Maximum number of file lines to print.}
}
\value{
An object of type \code{t2d_opt} consisting of a \code{data.frame} with
  elements \code{file}, file name(s) of the optional input file(s), and \code{value},
  an object of type \code{t2d_opt_LINES} that is essentially a \code{list} of
  \code{character} vectors where each element represents the contents of an
  optional input file.
}
\description{
Initialise optional input files for TELEMAC-2D.
}
\note{
When providing optional input files to a \code{t2d} setup the user still
needs to add the respective keywords to the steering (cas) file, otherwise the
optional input will be ignored! The reason is that many optional input files
require additional settings (keywords in the cas file) that cannot be foreseen.

So far only text-based optional input files are supported (e.g.
\code{SECTIONS INPUT FILE} or \code{FORMATTED DATA FILE}) but no binary files.
}
\examples{
# t2d_opt object
opt_obj <- optionals(c("# test file", "col1 col2", "1 2", "3 4"), fname = "optional.txt")
opt_obj
str(opt_obj)

# values (lines of the file) as t2d_opt_LINES object
opt_obj$value
str(opt_obj$value)

# multiple optional files
opt_obj <- optionals(list(c("# test file", "col1 col2", "1 2", "3 4"),
                          c("# test file 2", "col1 col2", "5 6", "7 8")),
                     fname = c("optional.txt", "optional2.txt"))
print(opt_obj, n = 4)

# change individual values via list methods
opt_obj$value[[1]][3] <- c("10 20")
opt_obj
}
