% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t2d.R
\name{t2d}
\alias{t2d}
\alias{print.t2d}
\title{Initialise a TELEMAC-2D project}
\usage{
t2d(title = "", wdir = ".", cas, geo, cli, res = NULL, opt = NULL, exec = NULL)

\method{print}{t2d}(x, ...)
}
\arguments{
\item{title}{\code{character} string giving the title of the project (argument
\code{TITLE} in the steering file).}

\item{wdir}{\code{character} string, the project directory were inputs and outputs
will be written to. TELEMAC-2D's input filenames must be relative to this directory!
Default: current working directory.}

\item{cas}{Passed to \code{\link{cas}} (preferably a \code{t2d_cas}) object).}

\item{geo}{Passed to \code{\link{geo}} (preferably a \code{t2d_geo}) object).}

\item{cli}{Passed to \code{\link{cli}} (preferably a \code{t2d_cli}) object).}

\item{res}{Passed to \code{\link{results}}. Can be the name of an existing
results file or left empty at the beginning in which case an empty template
object will be generated.}

\item{opt}{Object of class \code{t2d_opt} (if any; default: \code{NULL}).}

\item{exec}{\code{character} string specifying the TELEMAC-2D executable (system command).
Default: \code{NULL}. Only required for \code{\link{simulate_t2d}} to work.}

\item{x}{An object of class \code{t2d}.}

\item{...}{Optional arguments passed to \code{print} methods.}
}
\value{
An object of class \code{t2d}, that is a list with elements \code{title},
\code{wdir}, \code{exec}, \code{cas}, \code{geo}, \code{cli}, \code{res}, and \code{opt}.
The latter five are objects of type \code{t2d_*}.
}
\description{
Initialises a project for 2-dimensional hydrodynamic modelling with TELEMAC-2D.
}
\details{
First, make sure TELEMAC-2D is installed and works!
}
\examples{
library(sf)
library(raster)

# template setup with example data
bnd <- st_read(system.file("dem/boundary_lagos.gpkg", package = "telemac"))
dem_rast <- raster(system.file("dem/dem_merit_lagos.tif", package = "telemac"))
tin_obj <- tin(list(boundary = bnd), s = 90, a = 100^2, q = 30)
geo_obj <- geo(tin_obj, dem = dem_rast)
cli_obj <- cli(geo_obj)
cas_obj <- cas()

# TELEMAC-2D setup
t2d_obj <- t2d("Test setup", "path/to/wdir",
               cas = cas_obj, geo = geo_obj, cli = cli_obj)
t2d_obj

}
