% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual_reg.R
\name{dual_reg2}
\alias{dual_reg2}
\title{Dual Regression wrapper}
\usage{
dual_reg2(
  BOLD,
  BOLD2 = NULL,
  format = c("CIFTI", "xifti", "NIFTI", "nifti", "data"),
  GICA,
  scale = c("global", "local", "none"),
  scale_sm_FWHM = 2,
  detrend_DCT = 0,
  center_Bcols = FALSE,
  normA = FALSE,
  Q2 = 0,
  Q2_max = NULL,
  NA_limit = 0.1,
  brainstructures = c("left", "right"),
  mask = NULL,
  varTol = 1e-06,
  maskTol = 0.1,
  verbose = TRUE
)
}
\arguments{
\item{BOLD, BOLD2}{Subject-level fMRI data in one of the following formats:
a CIFTI file path, a \code{"xifti"} object, a NIFTI file path, a \code{"nifti"} object, or
\eqn{V \times T} numeric matrices, where \eqn{V} is the number of data locations and
\eqn{T} is the number of timepoints.

If \code{BOLD2} is provided it must be in the same format as \code{BOLD};
\code{BOLD} will be the test data and \code{BOLD2} will be the retest data.

If \code{BOLD2} is not provided, \code{BOLD} will be split in half;
the first half will be the test data and the second half will be the retest data.}

\item{format}{Expected format of \code{BOLD} and \code{BOLD2}. Should be one
of the following: a \code{"CIFTI"} file path, a \code{"xifti"} object, a
\code{"NIFTI"} file path, a \code{"nifti"} object, or a \code{"data"} matrix.}

\item{GICA}{Group ICA maps as a (vectorized) numeric matrix
(\eqn{V \times Q}). Its columns will be centered.}

\item{scale}{\code{"global"} (default), \code{"local"}, or \code{"none"}.
Global scaling will divide the entire data matrix by the mean image standard
deviation (\code{mean(sqrt(rowVars(BOLD)))}). Local scaling will divide each
data location's time series by its estimated standard deviation.}

\item{scale_sm_FWHM}{Only applies if \code{scale=="local"} and if \code{BOLD}
represents surface data. To smooth the standard deviation estimates used for
local scaling, provide the smoothing FWHM (default: \code{2}). As the FWHM
becomes large, local scaling approaches global scaling.}

\item{detrend_DCT}{Detrend the data? This is an integer number of DCT bases
to use for detrending. If \code{0} (default), do not detrend.}

\item{center_Bcols}{Center BOLD across columns (each image)? Default:
\code{FALSE} (not recommended).}

\item{normA}{Scale each IC timeseries (column of \eqn{A}) in the dual
regression estimates? Default: \code{FALSE} (not recommended). Note that the
product \eqn{A \times S} remains the same with either option.}

\item{Q2, Q2_max}{Obtain dual regression estimates after denoising? Denoising is
based on modeling and removing nuisance ICs. It may result in a cleaner
estimate for smaller datasets, but it may be unnecessary (and time-consuming)
for larger datasets.

Set \code{Q2} to control denoising: use a positive integer to specify the
number of nuisance ICs, \code{NULL} to have the number of nuisance ICs
estimated by PESEL, or zero (default) to skip denoising.

If \code{is.null(Q2)}, use \code{Q2_max} to specify the maximum number of
nuisance ICs that should be estimated by PESEL. \code{Q2_max} must be less
than \eqn{T * .75 - Q} where \eqn{T} is the minimum number of timepoints in
each fMRI scan and \eqn{Q} is the number of group ICs. If \code{NULL}
(default), \code{Q2_max} will be set to \eqn{T * .50 - Q}, rounded.}

\item{brainstructures}{Only applies if the entries of \code{BOLD} are CIFTI file paths.
Character vector indicating which brain structure(s)
to obtain: \code{"left"} (left cortical surface), \code{"right"} (right
cortical surface) and/or \code{"subcortical"} (subcortical and cerebellar
gray matter). Can also be \code{"all"} (obtain all three brain structures).
Default: \code{c("left","right")} (cortical surface only).}

\item{mask}{Required if and only if the entries of \code{BOLD} are NIFTI file paths or
\code{"nifti"} objects. This is a brain map formatted as a binary array of the same
size as the fMRI data, with \code{TRUE} corresponding to in-mask voxels.}

\item{varTol}{Tolerance for variance of each data location. For each scan,
locations which do not meet this threshold are masked out of the analysis.
Default: \code{1e-6}. Variance is calculated on the original data, before
any normalization. Set to \code{0} to avoid removing locations due to
low variance.}

\item{maskTol}{Tolerance for number of locations masked out due to low
variance or missing values. If more than this many locations are masked out,
this subject is skipped without calculating dual regression. \code{maskTol}
can be specified either as a proportion of the number of locations (between
zero and one), or as a number of locations (integers greater than one).
Default: \code{.1}, i.e. up to 10\\% of locations can be masked out.

If \code{BOLD2} is provided, masks are calculated for each scan and then
the intersection of the masks is used.}

\item{verbose}{Display progress updates? Default: \code{TRUE}.}
}
\value{
The dual regression \strong{S} matrices, or \code{NULL} if dual
regression was skipped due to too many masked data locations.
}
\description{
Wrapper to \code{dual_reg} used by \code{estimate_template}. The format of \code{BOLD}
(and \code{BOLD2}) must be provided, and \code{GICA} must be vectorized if applicable.
}
\keyword{internal}
