% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tenAR.R
\name{matAR.RR.se}
\alias{matAR.RR.se}
\title{Asymptotic Covariance Matrix of One-Term Reduced rank MAR(1) Model}
\usage{
matAR.RR.se(A1,A2,k1,k2,method,Sigma.e=NULL,Sigma1=NULL,Sigma2=NULL,RU1=diag(k1),
RV1=diag(k1),RU2=diag(k2),RV2=diag(k2),mpower=100)
}
\arguments{
\item{A1}{left coefficient matrix.}

\item{A2}{right coefficient matrix.}

\item{k1}{rank of \eqn{A_1}.}

\item{k2}{rank of \eqn{A_2}.}

\item{method}{character string, specifying the method of the estimation to be used. \describe{
 \item{\code{"RRLSE",}}{Least squares.}
 \item{\code{"RRMLE",}}{MLE under a separable cov(vec(\eqn{E_t})).}
}}

\item{Sigma.e}{only if \code{method} = "RRLSE". Cov(vec(\eqn{E_t})) = Sigma.e: covariance matrix of dimension \eqn{(d_1 d_2) \times (d_1 d_2)}}

\item{Sigma1, Sigma2}{only if \code{method} = "RRMLE". Cov(vec(\eqn{E_t})) = \eqn{\Sigma_2 \otimes \Sigma_1}. \eqn{\Sigma_i} is \eqn{d_i \times d_i}, \eqn{i=1,2}.}

\item{RU1, RV1, RU2, RV2}{orthogonal rotations of \eqn{U_1,V_1,U_2,V_2}, e.g., new_U1=U1 \code{RU1}.}

\item{mpower}{truncate the VMA(\eqn{\infty}) representation of vec(\eqn{X_t}) at \code{mpower} for the purpose of calculating the autocovariances. The default is 100.}
}
\value{
a list containing the following:\describe{
\item{\code{Sigma}}{asymptotic covariance matrix of (vec(\eqn{\hat A_1}),vec(\eqn{\hat A_2^T})).}
\item{\code{Theta1.u}}{asymptotic covariance matrix of vec(\eqn{\hat U_1}).}
\item{\code{Theta1.v}}{asymptotic covariance matrix of vec(\eqn{\hat V_1}).}
\item{\code{Theta2.u}}{asymptotic covariance matrix of vec(\eqn{\hat U_2}).}
\item{\code{Theta2.v}}{asymptotic covariance matrix of vec(\eqn{\hat V_2}).}
}
}
\description{
Asymptotic covariance matrix of the reduced rank MAR(1) model. If \code{Sigma1} and \code{Sigma2} is provided in input,
we assume a separable covariance matrix, Cov(vec(\eqn{E_t})) = \eqn{\Sigma_2 \otimes \Sigma_1}.
}
\references{
Han Xiao, Yuefeng Han, Rong Chen and Chengcheng Liu, Reduced Rank Autoregressive Models for Matrix Time Series.
}
