% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_network}
\alias{simulate_network}
\title{Fast Version of tergm::simulate.network for networkLite Object}
\usage{
simulate_network(p, el, coef.form, coef.diss, save.changes = FALSE)
}
\arguments{
\item{p}{A list of network-related nodal covariates and related terms that
is produced with \code{\link{stergm_prep}}.}

\item{el}{A two-column matrix of current edges (edgelist) with an attribute
variable \code{n} containing the total current network size.}

\item{coef.form}{Vector of coefficients associated with the formation formula.}

\item{coef.diss}{Vector of coefficients associated with the dissolution formula.}

\item{save.changes}{Logical, if \code{TRUE}, saves a matrix of changed edges
as an attribute of the output edgelist matrix.}
}
\value{
Returns an updated network edgelist object, typically stored on the master
\code{dat} list object, based on the model simulation. If \code{save.changes}
is \code{TRUE}, also returns a list of new edges and disolved edges with the
resimulation.
}
\description{
Resimulates a networkLite object given thin network data structure,
             edgelist, and STERGM model coefficients.
}
\details{
This function is used within the network resimulation module in \code{EpiModel}
to update temporal ERGMs based on the model coefficients and current network
structure. If network structure (e.g., number of nodes) or nodal attributes
has changed since the last simulation, this network resimulation should be run
only after \code{\link{updateModelTermInputs}}.
}
\examples{
library("EpiModel")

# Set seed for reproducibility
set.seed(12345)

nw <- network.initialize(n = 100, directed = FALSE)
nw <- set.vertex.attribute(nw, "group", rep(0:1, each = 50))
formation <- ~edges + nodefactor("group")
target.stats <- c(15, 10)
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
x <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

param <- param.net(inf.prob = 0.3)
init <- init.net(i.num = 10)
control <- control.net(type = "SI", nsteps = 100, nsims = 5, depend = TRUE)

# Full network structure after initialization
dat <- initialize.net(x, param, init, control)
str(dat, max.level = 1)

# networkLite representation used by tergmLite
dat <- init_tergmLite(dat)

# Current network structure
dat$el[[1]]

# New network structure
dat$el[[1]] <- simulate_network(p = dat$p[[1]],
                                el = dat$el[[1]],
                                coef.form = dat$nwparam[[1]]$coef.form,
                                coef.diss = dat$nwparam[[1]]$coef.diss$coef.adj,
                                save.changes = TRUE)
dat$el[[1]]

# Specific changes listed under changes list
#    (new edges: to = 1; dissolved edges: to = 0):
attributes(dat$el[[1]])$changes

}
