% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_cols_by_groups.R
\name{split_cols_by_groups}
\alias{split_cols_by_groups}
\title{Split Columns by Groups of Levels}
\usage{
split_cols_by_groups(lyt, var, groups_list = NULL, ref_group = NULL, ...)
}
\arguments{
\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{groups_list}{(named \code{list} of \code{character})\cr specifies the new group levels via the names and the
levels that belong to it in the character vectors that are elements of the list.}

\item{ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{...}{additional arguments to \code{\link[rtables:split_cols_by]{rtables::split_cols_by()}} in order. For instance, to
control formats (\code{format}), add a joint column for all groups (\code{incl_all}).}
}
\value{
A layout object suitable for passing to further layouting functions. Adding
this function to an \code{rtable} layout will add a column split including the given
groups to the table layout.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
# 1 - Basic use

# Without group combination `split_cols_by_groups` is
# equivalent to [rtables::split_cols_by()].
basic_table() \%>\%
  split_cols_by_groups("ARM") \%>\%
  add_colcounts() \%>\%
  analyze("AGE") \%>\%
  build_table(DM)

# Add a reference column.
basic_table() \%>\%
  split_cols_by_groups("ARM", ref_group = "B: Placebo") \%>\%
  add_colcounts() \%>\%
  analyze(
    "AGE",
    afun = function(x, .ref_group, .in_ref_col) {
      if (.in_ref_col) {
        in_rows("Diff Mean" = rcell(NULL))
      } else {
        in_rows("Diff Mean" = rcell(mean(x) - mean(.ref_group), format = "xx.xx"))
      }
    }
  ) \%>\%
  build_table(DM)

# 2 - Adding group specification

# Manual preparation of the groups.
groups <- list(
  "Arms A+B" = c("A: Drug X", "B: Placebo"),
  "Arms A+C" = c("A: Drug X", "C: Combination")
)

# Use of split_cols_by_groups without reference column.
basic_table() \%>\%
  split_cols_by_groups("ARM", groups) \%>\%
  add_colcounts() \%>\%
  analyze("AGE") \%>\%
  build_table(DM)

# Including differentiated output in the reference column.
basic_table() \%>\%
  split_cols_by_groups("ARM", groups_list = groups, ref_group = "Arms A+B") \%>\%
  analyze(
    "AGE",
    afun = function(x, .ref_group, .in_ref_col) {
      if (.in_ref_col) {
        in_rows("Diff. of Averages" = rcell(NULL))
      } else {
        in_rows("Diff. of Averages" = rcell(mean(x) - mean(.ref_group), format = "xx.xx"))
      }
    }
  ) \%>\%
  build_table(DM)

# 3 - Binary list dividing factor levels into reference and treatment

# `combine_groups` defines reference and treatment.
groups <- combine_groups(
  fct = DM$ARM,
  ref = c("A: Drug X", "B: Placebo")
)
groups

# Use group definition without reference column.
basic_table() \%>\%
  split_cols_by_groups("ARM", groups_list = groups) \%>\%
  add_colcounts() \%>\%
  analyze("AGE") \%>\%
  build_table(DM)

# Use group definition with reference column (first item of groups).
basic_table() \%>\%
  split_cols_by_groups("ARM", groups, ref_group = names(groups)[1]) \%>\%
  add_colcounts() \%>\%
  analyze(
    "AGE",
    afun = function(x, .ref_group, .in_ref_col) {
      if (.in_ref_col) {
        in_rows("Diff Mean" = rcell(NULL))
      } else {
        in_rows("Diff Mean" = rcell(mean(x) - mean(.ref_group), format = "xx.xx"))
      }
    }
  ) \%>\%
  build_table(DM)

}
\seealso{
\code{\link[rtables:split_cols_by]{rtables::split_cols_by()}}
}
