% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_grid.R
\name{stack_grobs}
\alias{stack_grobs}
\title{Stack multiple grobs}
\usage{
stack_grobs(
  ...,
  grobs = list(...),
  padding = grid::unit(2, "line"),
  vp = NULL,
  gp = NULL,
  name = NULL
)
}
\arguments{
\item{...}{grobs.}

\item{grobs}{(\code{list} of \code{grob})\cr a list of grobs.}

\item{padding}{(\code{grid::unit})\cr unit of length 1, space between each grob.}

\item{vp}{(\code{viewport} or \code{NULL})\cr a \code{\link[=viewport]{viewport()}} object (or \code{NULL}).}

\item{gp}{(\code{gpar})\cr a \code{\link[=gpar]{gpar()}} object.}

\item{name}{(\code{string})\cr a character identifier for the grob.}
}
\value{
A \code{grob}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Stack grobs as a new grob with 1 column and multiple rows layout.
}
\examples{
library(grid)

g1 <- circleGrob(gp = gpar(col = "blue"))
g2 <- circleGrob(gp = gpar(col = "red"))
g3 <- textGrob("TEST TEXT")
grid.newpage()
grid.draw(stack_grobs(g1, g2, g3))

showViewport()

grid.newpage()
pushViewport(viewport(layout = grid.layout(1, 2)))
vp1 <- viewport(layout.pos.row = 1, layout.pos.col = 2)
grid.draw(stack_grobs(g1, g2, g3, vp = vp1, name = "test"))

showViewport()
grid.ls(grobs = TRUE, viewports = TRUE, print = FALSE)

}
