% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_patients_with_event.R
\name{count_patients_with_event}
\alias{count_patients_with_event}
\alias{s_count_patients_with_event}
\alias{a_count_patients_with_event}
\title{Count the number of patients with a particular event}
\usage{
count_patients_with_event(
  lyt,
  vars,
  filters,
  riskdiff = FALSE,
  na_str = default_na_str(),
  nested = TRUE,
  show_labels = ifelse(length(vars) > 1, "visible", "hidden"),
  ...,
  table_names = vars,
  .stats = "count_fraction",
  .stat_names = NULL,
  .formats = list(count_fraction = format_count_fraction_fixed_dp),
  .labels = NULL,
  .indent_mods = NULL
)

s_count_patients_with_event(
  df,
  .var,
  .N_col = ncol(df),
  .N_row = nrow(df),
  ...,
  filters,
  denom = c("n", "N_col", "N_row")
)

a_count_patients_with_event(
  df,
  labelstr = "",
  ...,
  .stats = NULL,
  .stat_names = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{filters}{(\code{character})\cr a character vector specifying the column names and flag variables
to be used for counting the number of unique identifiers satisfying such conditions.
Multiple column names and flags are accepted in this format
\code{c("column_name1" = "flag1", "column_name2" = "flag2")}.
Note that only equality is being accepted as condition.}

\item{riskdiff}{(\code{flag})\cr whether a risk difference column is present. When set to \code{TRUE}, \code{\link[=add_riskdiff]{add_riskdiff()}} must be
used as \code{split_fun} in the prior column split of the table layout, specifying which columns should be compared.
See \code{\link[=stat_propdiff_ci]{stat_propdiff_ci()}} for details on risk difference calculation.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.

Options are: \verb{'n', 'count', 'count_fraction', 'count_fraction_fixed_dp', 'n_blq'}}

\item{.stat_names}{(\code{character})\cr names of the statistics that are passed directly to name single statistics
(\code{.stats}). This option is visible when producing \code{\link[rtables:data.frame_export]{rtables::as_result_df()}} with \code{make_ard = TRUE}.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr name of the column that contains the unique identifier.}

\item{.N_col}{(\code{integer(1)})\cr column-wise N (column count) for the full column being analyzed that is typically
passed by \code{rtables}.}

\item{.N_row}{(\code{integer(1)})\cr row-wise N (row group count) for the group of observations being analyzed
(i.e. with no column-based subsetting) that is typically passed by \code{rtables}.}

\item{denom}{(\code{string})\cr choice of denominator for proportion. Options are:
\itemize{
\item \code{n}: number of values in this row and column intersection.
\item \code{N_row}: total number of values in this row across columns.
\item \code{N_col}: total number of values in this column across rows.
}}

\item{labelstr}{(\code{string})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}
}
\value{
\itemize{
\item \code{count_patients_with_event()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_patients_with_event()} to the table layout.
}

\itemize{
\item \code{s_count_patients_with_event()} returns the count and fraction of unique identifiers with the defined event.
}

\itemize{
\item \code{a_count_patients_with_event()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=count_patients_with_event]{count_patients_with_event()}} creates a layout element to calculate patient counts for a
user-specified set of events.

This function analyzes primary analysis variable \code{vars} which indicates unique subject identifiers. Events
are defined by the user as a named vector via the \code{filters} argument, where each name corresponds to a
variable and each value is the value(s) that that variable takes for the event.

If there are multiple records with the same event recorded for a patient, only one occurrence is counted.
}
\section{Functions}{
\itemize{
\item \code{count_patients_with_event()}: Layout-creating function which can take statistics function
arguments and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_count_patients_with_event()}: Statistics function which counts the number of patients for which
the defined event has occurred.

\item \code{a_count_patients_with_event()}: Formatted analysis function which is used as \code{afun}
in \code{count_patients_with_event()}.

}}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_colcounts() \%>\%
  count_values(
    "STUDYID",
    values = "AB12345",
    .stats = "count",
    .labels = c(count = "Total AEs")
  ) \%>\%
  count_patients_with_event(
    "SUBJID",
    filters = c("TRTEMFL" = "Y"),
    .labels = c(count_fraction = "Total number of patients with at least one adverse event"),
    table_names = "tbl_all"
  ) \%>\%
  count_patients_with_event(
    "SUBJID",
    filters = c("TRTEMFL" = "Y", "AEOUT" = "FATAL"),
    .labels = c(count_fraction = "Total number of patients with fatal AEs"),
    table_names = "tbl_fatal"
  ) \%>\%
  count_patients_with_event(
    "SUBJID",
    filters = c("TRTEMFL" = "Y", "AEOUT" = "FATAL", "AEREL" = "Y"),
    .labels = c(count_fraction = "Total number of patients with related fatal AEs"),
    .indent_mods = c(count_fraction = 2L),
    table_names = "tbl_rel_fatal"
  )

build_table(lyt, tern_ex_adae, alt_counts_df = tern_ex_adsl)

s_count_patients_with_event(
  tern_ex_adae,
  .var = "SUBJID",
  filters = c("TRTEMFL" = "Y"),
)

s_count_patients_with_event(
  tern_ex_adae,
  .var = "SUBJID",
  filters = c("TRTEMFL" = "Y", "AEOUT" = "FATAL")
)

s_count_patients_with_event(
  tern_ex_adae,
  .var = "SUBJID",
  filters = c("TRTEMFL" = "Y", "AEOUT" = "FATAL"),
  denom = "N_col",
  .N_col = 456
)

a_count_patients_with_event(
  tern_ex_adae,
  .var = "SUBJID",
  filters = c("TRTEMFL" = "Y"),
  .N_col = 100,
  .N_row = 100
)

}
\seealso{
\code{\link[=count_patients_with_flags]{count_patients_with_flags()}}
}
