% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testcorr.R
\name{cc.test}
\alias{cc.test}
\title{Testing zero cross-correlation}
\usage{
cc.test(x, y, max.lag, alpha = 0.05, lambda = 2.576, plot = TRUE,
        table = TRUE, var.names = NULL, scale.font = 1)
}
\arguments{
\item{x}{A numeric vector or a univariate numeric time series object or a data frame.}

\item{y}{A numeric vector or a univariate numeric time series object or a data frame.}

\item{max.lag}{Maximum lag at which to calculate the test statistics.}

\item{alpha}{Significance level for hypothesis testing used in the plots. Default is 0.05.}

\item{lambda}{Threshold in \eqn{\widetilde{Q}}{Q-tilde} test statistics. Default is 2.576.}

\item{plot}{Logical. If TRUE the sample cross-correlations with their confidence bands and the cumulative statistics with their critical values are plotted. Default is TRUE.}

\item{table}{Logical. If TRUE the sample cross-correlations, the confidence bands, the test statistics and their p-values are printed out. Default is TRUE.}

\item{var.names}{NULL or a character string specifying the variable names. If NULL and x,y have names, the names of x,y are used. If NULL and x,y have no names, the string c("x","y") is used. Default is NULL.}

\item{scale.font}{A positive number indicating the scaling of the font size in the plots. Default is 1.}
}
\value{
An object of class "cc.test", which is a list with the following components:
\item{lag}{The lags used.}
\item{cc}{The sample cross-correlations.}
\item{scb}{The lower and upper limit of the confidence bands based on the standard test statistics.}
\item{rcb}{The lower and upper limit of the confidence bands based on the robust test statistics.}
\item{t}{The \eqn{t}{t} test statistics.}
\item{pvt}{The p-values for the \eqn{t}{t} test statistics.}
\item{ttilde}{The \eqn{\widetilde{t}}{t-tilde} test statistics.}
\item{pvtttilde}{The p-values for the \eqn{\widetilde{t}}{t-tilde} test statistics.}
\item{hb}{The \eqn{HB} test statistics.}
\item{pvhb}{The p-values for the \eqn{HB} test statistics.}
\item{qtilde}{The \eqn{\widetilde{Q}}{Q-tilde} test statistics.}
\item{pvqtilde}{The p-values for the \eqn{\widetilde{Q}}{Q-tilde} test statistics.}
}
\description{
The function cc.test computes the test statistics for examining the null hypothesis
of zero cross-correlation for bivariate time series given in Dalla, Giraitis and Phillips (2020).
}
\details{
The standard \eqn{t} and robust \eqn{\widetilde{t}}{t-tilde} statistics are for testing the null hypothesis \eqn{H_0:\rho_k=0}{H[0]:\rho[k]=0} at lags \eqn{k=-max.lag,...,-1,0,1,max.lag},
and the standard \eqn{HB} and robust \eqn{\widetilde{Q}}{Q-tilde} statistics are for testing the null hypothesis \eqn{H_0:\rho_0=...=\rho_m=0}{H[0]:\rho[0]=...=\rho[m]=0} at lags \eqn{m=-max.lag,...,-1,0,1,max.lag},
where \eqn{\rho_k}{\rho[k]} denotes the cross-correlation of \eqn{x_t}{x[t]} and \eqn{y_{t-k}}{y[t-k]} at lag \eqn{k}.
}
\note{
Missing values are not allowed.
}
\examples{
x <- rnorm(100)
y <- rnorm(100)
cc.test(x, y, max.lag = 10)
}
\references{
Dalla, V., Giraitis, L. and Phillips, P. C. B. (2020). "Robust Tests for White Noise and Cross-Correlation". Cowles Foundation, Discussion Paper No. 2194, \url{https://cowles.yale.edu/sites/default/files/files/pub/d21/d2194-r.pdf}.
}
\author{
Violetta Dalla, Liudas Giraitis and Peter C. B. Phillips
}
