% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal2var.R
\name{equa2vartest}
\alias{equa2vartest}
\title{Bootstrap test for equality of two (2) population variances}
\usage{
equa2vartest(x1, x2, a, B)
}
\arguments{
\item{x1}{first sample vector of data or observations}

\item{x2}{second sample vector of data or observations}

\item{a}{significance level alpha}

\item{B}{number of bootstrap samples. At least 500 is recommended.}
}
\value{
list consisting of a non-numeric decision whether to reject the null hypothesis or not, the significance level, and the number of bootstrap samples used
}
\description{
Testing equality of two (2) population variances against the alternative that both variances are not equal.
}
\examples{


x1=sqrt(10)*runif(7, -sqrt(3), sqrt(3) )
x2=sqrt(1)*runif(7, -sqrt(3), sqrt(3) )
equa2vartest(x1,x2,0.05, 500)



x1=sqrt(1)*rexp(7)
x2=sqrt(1)*rexp(7)
equa2vartest(x1,x2,0.01, 1000)



}
\references{
Cahoy, DO (2010), \emph{A Bootstrap Test For Equality Of Variances,} Computational Statistics & Data Analysis, 54(10), 2306-2316.
\url{https://doi.org/10.1016/j.csda.2010.04.012}
}
