% Generated by roxygen2 (4.0.2): do not edit by hand
\name{expect-compare}
\alias{expect-compare}
\alias{expect_less_than}
\alias{expect_more_than}
\alias{is_less_than}
\alias{is_more_than}
\title{Expectation: is returned value less or greater than specified value?}
\usage{
is_less_than(expected, label = NULL, ...)

expect_less_than(object, expected, ..., info = NULL, label = NULL,
  expected.label = NULL)

is_more_than(expected, label = NULL, ...)

expect_more_than(object, expected, ..., info = NULL, label = NULL,
  expected.label = NULL)
}
\arguments{
\item{expected}{Expected value}

\item{label}{For full form, label of expected object used in error
messages. Useful to override default (deparsed expected expression) when
doing tests in a loop.  For short cut form, object label. When
\code{NULL}, computed from deparsed object.}

\item{...}{other values passed to \code{\link{all.equal}}}

\item{object}{object to test}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{expected.label}{Equivalent of \code{label} for shortcut form.}
}
\description{
This is useful for ensuring returned value is below a ceiling or above
a floor.
}
\examples{
a <- 9
expect_less_than(a, 10)

\dontrun{
expect_less_than(11, 10)
}

a <- 11
expect_more_than(a, 10)
\dontrun{
expect_more_than(9, 10)
}
}
\seealso{
Other expectations: \code{\link{equals_reference}},
  \code{\link{expect_equal_to_reference}};
  \code{\link{equals}}, \code{\link{expect_equal}};
  \code{\link{expect_equivalent}},
  \code{\link{is_equivalent_to}};
  \code{\link{expect_error}}, \code{\link{throws_error}};
  \code{\link{expect_false}}, \code{\link{expect_true}},
  \code{\link{is_false}}, \code{\link{is_true}};
  \code{\link{expect_identical}},
  \code{\link{is_identical_to}}; \code{\link{expect_is}},
  \code{\link{is_a}}; \code{\link{expect_match}},
  \code{\link{matches}}; \code{\link{expect_message}},
  \code{\link{shows_message}}; \code{\link{expect_named}},
  \code{\link{has_names}}; \code{\link{expect_null}},
  \code{\link{is_null}}; \code{\link{expect_output}},
  \code{\link{prints_text}}; \code{\link{expect_warning}},
  \code{\link{gives_warning}};
  \code{\link{takes_less_than}}
}

