% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evm.simSetSeed.R
\name{evmSimSetSeed}
\alias{evmSimSetSeed}
\title{Set the seed from a fitted evmSim object.}
\usage{
evmSimSetSeed(x)
}
\arguments{
\item{x}{An object of class \code{evmSim}, as returned by \code{evm} using
\code{method = "simulate"}.}
}
\description{
Set the seed from a fitted \code{evmSim} object to ensure reproducibility of
output.
}
\details{
Sets the seed to the value used to fit the model.
}
\examples{

# data <- rnorm(1000)
# mod <- evm(data, qu=.7, method="simulate")
# evmSimSetSeed(mod)
# mod1 <- evm(data, qu=.7, method="simulate") # this produces the same MCMC output as mod

}
\author{
Harry Southworth
}
\seealso{
\code{\link{evm}}
}

