% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,lm-method}
\alias{extract,lm-method}
\alias{extract.lm}
\title{\code{\link{extract}} method for \code{lm} objects}
\usage{
\S4method{extract}{lm}(
  model,
  include.rsquared = TRUE,
  include.adjrs = TRUE,
  include.nobs = TRUE,
  include.fstatistic = FALSE,
  include.rmse = FALSE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.rsquared}{Report R^2 in the GOF block?}

\item{include.adjrs}{Report adjusted R^2 in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.fstatistic}{Report the F-statistic in the GOF block?}

\item{include.rmse}{Report the root mean square error (RMSE; = residual
standard deviation) in the GOF block?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{lm} objects created by the
\code{\link[stats]{lm}} function in the \pkg{stats} package.
}
