% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texreg.R
\name{createTexreg}
\alias{createTexreg}
\title{Constructor for \linkS4class{texreg} objects}
\usage{
createTexreg(
  coef.names,
  coef,
  se = numeric(0),
  pvalues = numeric(0),
  ci.low = numeric(0),
  ci.up = numeric(0),
  gof.names = character(0),
  gof = numeric(0),
  gof.decimal = logical(0),
  model.name = character(0)
)
}
\arguments{
\item{coef.names}{The names for the covariates in a model as a
\code{character} vector (= row names).}

\item{coef}{The coefficients as a \code{numeric} vector. Can have length
zero.}

\item{se}{The standard errors as a \code{numeric} vector. Can have length
zero.}

\item{pvalues}{The p-values as a \code{numeric} vector. Can have length zero.}

\item{ci.low}{The lower bounds of the confidence intervals as a
\code{numeric} vector. Can have length zero.}

\item{ci.up}{The upper bounds of the confidence intervals as a
\code{numeric} vector. Can have length zero.}

\item{gof.names}{Names of the goodness-of-fit statistics as a
\code{character} vector. Can have length zero.}

\item{gof}{Goodness-of-fit statistics as a \code{numeric} vector. Can have
length zero.}

\item{gof.decimal}{A \code{logical} vector with as many elements as the
\code{gof} argument, indicating whether the respective GOF statistic is a
double (\code{TRUE}) or integer (\code{FALSE}) number or whether it is a
\code{character} entry (\code{NA}).}

\item{model.name}{A name for the statistical model. Can be a \code{character}
vector of length zero if there is no model name.}
}
\value{
A \linkS4class{texreg} object representing the statistical model.
}
\description{
Constructor for \linkS4class{texreg} objects.
}
\details{
This function creates a \linkS4class{texreg} object. A \linkS4class{texreg}
object contains information about coefficients, standard errors, p-values
(optional), and about goodness-of-fit statistics. Instead of standard
errors and p-values, a \linkS4class{texreg} object may also contain upper and
lower bounds of a confidence interval. \linkS4class{texreg} objects are used
by the \code{\link{texreg}} function to create LaTeX tables and other
representations of the model results.
}
\examples{
library("nlme")  # load library for fitting linear mixed effects models
model <- lme(distance ~ age, data = Orthodont, random = ~ 1)  # estimate
coefficient.names <- rownames(summary(model)$tTable)  # extract coef names
coefficients <- summary(model)$tTable[, 1]  # extract coefficient values
standard.errors <- summary(model)$tTable[, 2]  # extract standard errors
significance <- summary(model)$tTable[, 5]  #extract p-values

lik <- summary(model)$logLik  # extract log likelihood
aic <- summary(model)$AIC  # extract AIC
bic <- summary(model)$BIC  # extract BIC
n <- nobs(model)  # extract number of observations
gof <- c(aic, bic, lik, n)  # create a vector of GOF statistics
gof.names <- c("AIC", "BIC", "Log Likelihood", "Num. obs.")  # names of GOFs
decimal.places <- c(TRUE, TRUE, TRUE, FALSE)  # last one is a count variable

# create the texreg object
tr <- createTexreg(coef.names = coefficient.names,
                   coef = coefficients,
                   se = standard.errors,
                   pvalues = significance,
                   gof.names = gof.names,
                   gof = gof,
                   gof.decimal = decimal.places)

}
\references{
Leifeld, Philip (2013). texreg: Conversion of Statistical Model
  Output in R to LaTeX and HTML Tables. Journal of Statistical Software
  55(8): 1-24. \doi{10.18637/jss.v055.i08}.
}
\seealso{
\code{\link{extract}}
}
\author{
Philip Leifeld
}
