% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,fixest-method}
\alias{extract,fixest-method}
\alias{extract.fixest}
\title{\code{\link{extract}} method for \code{fixest} objects}
\usage{
\S4method{extract}{fixest}(
  model,
  include.nobs = TRUE,
  include.groups = TRUE,
  include.rsquared = TRUE,
  include.adjrs = TRUE,
  include.proj.stats = TRUE,
  include.deviance = TRUE,
  include.loglik = TRUE,
  include.pseudors = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.nobs}{Report the number of observations?}

\item{include.groups}{Report the number of groups?}

\item{include.rsquared}{Report R^2? (OLS only)}

\item{include.adjrs}{Report adjusted R^2? (OLS only)}

\item{include.proj.stats}{Include statistics for projected model? (OLS only)}

\item{include.deviance}{Report the deviance? (GLM/MLE only)}

\item{include.loglik}{Report the log likelihood? (GLM/MLE only)}

\item{include.pseudors}{Report Pseudo-R^2? (GLM/MLE only)}

\item{...}{Custom parameters, which are handed over to the
\code{\link[fixest]{coeftable}} method for the \code{fixest} object.}
}
\description{
\code{\link{extract}} method for \code{fixest} objects created by the
model fitting functions in the \pkg{fixest} package. The method can deal with
OLS (fitted by \code{\link[fixest]{feols}}) and GLM/MLE models (fitted by
\code{\link[fixest]{feglm}} and other functions).
}
\author{
Christopher Poliquin, Philip Leifeld
}
