% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_4_textPredict.R
\name{textPredict}
\alias{textPredict}
\title{Predict scores or classification from, e.g., textTrain.}
\usage{
textPredict(
  model_info,
  word_embeddings,
  x_append = NULL,
  type = NULL,
  dim_names = TRUE,
  ...
)
}
\arguments{
\item{model_info}{(model object) Model info (e.g., saved output from textTrain,
textTrainRegression or textRandomForest).}

\item{word_embeddings}{(tibble) Word embeddings}

\item{x_append}{(tibble) Variables to be appended after the word embeddings (x).}

\item{type}{(string) Type of prediction; e.g., "prob", "class".}

\item{dim_names}{(boolean) Account for specific dimension names from textEmbed()
(rather than generic names including Dim1, Dim2 etc.). If FALSE the models need to have been trained on
word embeddings created with dim_names FALSE, so that embeddings were only called Dim1, Dim2 etc.}

\item{...}{Setting from stats::predict can be called.}
}
\value{
Predicted scores from word embeddings.
}
\description{
Predict scores or classification from, e.g., textTrain.
}
\examples{
word_embeddings <- word_embeddings_4
ratings_data <- Language_based_assessment_data_8
}
\seealso{
see \code{\link{textTrain}} \code{\link{textTrainLists}}
\code{\link{textTrainRandomForest}} \code{\link{textSimilarityTest}}
}
