% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_0_text_install.R
\name{textrpp_install}
\alias{textrpp_install}
\alias{textrpp_install_virtualenv}
\title{Install text required python packages in conda or virtualenv environment}
\usage{
textrpp_install(
  conda = "auto",
  update_conda = FALSE,
  force_conda = FALSE,
  rpp_version = "rpp_version_system_specific_defaults",
  python_version = "python_version_system_specific_defaults",
  envname = "textrpp_condaenv",
  pip = TRUE,
  python_path = NULL,
  prompt = TRUE
)

textrpp_install_virtualenv(
  rpp_version = c("torch==2.0.0", "transformers==4.19.2", "numpy", "pandas", "nltk"),
  python_path = "/usr/local/bin/python3.9",
  pip_version = NULL,
  envname = "textrpp_virtualenv",
  prompt = TRUE
)
}
\arguments{
\item{conda}{character; path to conda executable. Default "auto" which
automatically find the path}

\item{update_conda}{Boolean; update to the latest version of Miniconda after install?
(should be combined with force_conda = TRUE)}

\item{force_conda}{Boolean; force re-installation if Miniconda is already installed at the requested path?}

\item{rpp_version}{character; default is "rpp_version_system_specific_defaults", because diffent systems require
different combinations of python version and packages. It is also possible to
specify your own, such as c("torch==2.0.0", "transformers==4.19.2", "numpy", "pandas", "nltk", "scikit-learn",
"datasets", "evaluate").}

\item{python_version}{character; default is "python_version_system_specific_defaults". You can specify your
Python version for the condaenv yourself.
  installation.}

\item{envname}{character; name of the conda-environment to install text required python packages.
Default is "textrpp_condaenv".}

\item{pip}{\code{TRUE} to use pip for installing rpp If \code{FALSE}, conda
package manager with conda-forge channel will be used for installing rpp.}

\item{python_path}{character; path to Python in virtualenv installation}

\item{prompt}{logical; ask whether to proceed during the installation}

\item{pip_version}{character;}
}
\description{
Install text required python packages (rpp) in a self-contained environment.
For macOS and Linux-based systems, this will also install Python itself via a "miniconda" environment, for
  \code{textrpp_install}.  Alternatively, an existing conda installation may be
  used, by specifying its path.  The default setting of \code{"auto"} will
  locate and use an existing installation automatically, or download and
  install one if none exists.

  For Windows, automatic installation of miniconda installation is not currently
  available, so the user will need to
  \href{https://conda.io/projects/conda/en/latest/user-guide/install/index.html}{miniconda
   (or Anaconda) manually}.

If you wish to install Python in a "virtualenv", use the
  \code{textrpp_install_virtualenv} function. It requires that you have a python version
  and path to it (such as "/usr/local/bin/python3.9" for Mac and Linux.).
}
\examples{
\dontrun{
# install text required python packages in a miniconda environment (macOS and Linux)
textrpp_install(prompt = FALSE)

# install text required python packages to an existing conda environment
textrpp_install(conda = "~/anaconda/bin/")
}
\dontrun{
# install text required python packages in a virtual environment
textrpp_install_virtualenv()
}
}
