% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_RWMD.R
\docType{data}
\name{RelaxedWordMoversDistance}
\alias{RelaxedWordMoversDistance}
\alias{RWMD}
\title{Creates Relaxed Word Movers Distance (RWMD) model}
\format{\code{\link{R6Class}} object.}
\usage{
RelaxedWordMoversDistance

RWMD
}
\description{
RWMD model can be used to query the "relaxed word movers distance" from a document to a
collection of documents. RWMD tries to measure distance between query document and collection of documents by
calculating how hard is to transform words from query document into words from each document in collection.
For more detail see following article: \url{http://mkusner.github.io/publications/WMD.pdf}.
However in contrast to the article above we calculate "easiness" of the convertion of one word into another
by using \bold{cosine} similarity (but not a euclidean distance).
Also here in text2vec we've implemented effiient RWMD using the tricks from the
\href{https://arxiv.org/abs/1711.07227}{Linear-Complexity Relaxed Word Mover's Distance with GPU Acceleration} article.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
rwmd = RelaxedWordMoversDistance$new(x, embeddings)
rwmd$sim2(x)
}
}

\section{Methods}{

\describe{
  \item{\code{$new(x, embeddings)}}{Constructor for RWMD model.
        \code{x} - docuent-term matrix which represents collection of
        documents against which you want to perform queries. \code{embeddings} -
        matrix of word embeddings which will be used to calculate similarities
        between words (each row represents a word vector).}
  \item{\code{$sim(x)}}{calculates similarity from a collection of documents
  to collection query documents \code{x}.
  \code{x} here is a document-term matrix which represents the set of query documents}
  \item{\code{$dist(x)}}{calculates distance from a collection of documents
  to collection query documents \code{x}
  \code{x} here is a document-term matrix which represents the set of query documents}
}
}

\examples{
\dontrun{
library(text2vec)
library(rsparse)
data("movie_review")
tokens = word_tokenizer(tolower(movie_review$review))
v = create_vocabulary(itoken(tokens))
v = prune_vocabulary(v, term_count_min = 5, doc_proportion_max = 0.5)
it = itoken(tokens)
vectorizer = vocab_vectorizer(v)
dtm = create_dtm(it, vectorizer)
tcm = create_tcm(it, vectorizer, skip_grams_window = 5)
glove_model = GloVe$new(rank = 50, x_max = 10)
wv = glove_model$fit_transform(tcm, n_iter = 5)
# get average of main and context vectors as proposed in GloVe paper
wv = wv + t(glove_model$components)
rwmd_model = RelaxedWordMoversDistance$new(dtm, wv)
rwms = rwmd_model$sim2(dtm[1:10, ])
head(sort(rwms[1, ], decreasing = T))
}
}
\keyword{datasets}
