% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_contraction.R
\name{replace_contraction}
\alias{replace_contraction}
\title{Replace Contractions}
\usage{
replace_contraction(x, contraction.key = lexicon::key_contractions,
  ignore.case = TRUE, ...)
}
\arguments{
\item{x}{The text variable.}

\item{contraction.key}{A two column hash of contractions (column 1) and 
expanded form replacements (column 2).  Default is to use 
\code{\link[lexicon]{key_contractions}} data set.}

\item{ignore.case}{logical.  Should case be ignored?}

\item{\dots}{ignored.}
}
\value{
Returns a vector with contractions replaced.
}
\description{
This function replaces contractions with long form.
}
\examples{
\dontrun{
x <- c("Mr. Jones isn't going.",  
    "Check it out what's going on.",
    "He's here but didn't go.",
    "the robot at t.s. wasn't nice", 
    "he'd like it if i'd go away")

replace_contraction(x)
}
}
\keyword{contraction}
