% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexicon_nrc_vad.R
\name{lexicon_nrc_vad}
\alias{lexicon_nrc_vad}
\title{The NRC Valence, Arousal, and Dominance Lexicon}
\source{
\url{https://saifmohammad.com/WebPages/nrc-vad.html}
}
\usage{
lexicon_nrc_vad(dir = NULL, delete = FALSE, return_path = FALSE,
  clean = FALSE)
}
\arguments{
\item{dir}{Character, path to directory where data will be stored. If
\code{NULL}, \link[rappdirs]{user_cache_dir} will be used to determine path.}

\item{delete}{Logical, set \code{TRUE} to delete dataset.}

\item{return_path}{Logical, set \code{TRUE} to return the path of the dataset.}

\item{clean}{Logical, set \code{TRUE} to remove intermediate files. This can
greatly reduce the size. Defaults to FALSE.}
}
\value{
A tibble with 20.007 rows and 4 variables:
\describe{
  \item{word}{An English word}
  \item{Valence}{valence score of the word}
  \item{Arousal}{arousal score of the word}
  \item{Dominance}{dominance score of the word}
}
}
\description{
The NRC Valence, Arousal, and Dominance (VAD) Lexicon includes a list of
more than 20,000 English words and their valence, arousal, and dominance
scores. For a given word and a dimension (V/A/D), the scores range from 0
(lowest V/A/D) to 1 (highest V/A/D). The lexicon with its fine-grained real-
valued scores was created by manual annotation using best--worst scaling.
The lexicon is markedly larger than any of the existing VAD lexicons. We also
show that the ratings obtained are substantially more reliable than those in
existing lexicons.
}
\details{
License required for commercial use. Please contact Saif M. Mohammad
(saif.mohammad@nrc-cnrc.gc.ca).

Citation info:

Details of the NRC VAD Lexicon are available in this paper:

Obtaining Reliable Human Ratings of Valence, Arousal, and Dominance for
20,000 English Words.  Saif M. Mohammad. In Proceedings of the 56th Annual
Meeting of the Association for Computational Linguistics, Melbourne,
Australia, July 2018.

inproceedings\{vad-acl2018, \cr
title=\{Obtaining Reliable Human Ratings of Valence, Arousal, and Dominance for 20,000 English Words\}, \cr
author=\{Mohammad, Saif M.\}, \cr
booktitle=\{Proceedings of The Annual Conference of the Association for Computational Linguistics (ACL)\}, \cr
year=\{2018\}, \cr
address=\{Melbourne, Australia\} \cr
\}
}
\examples{
\donttest{
lexicon_nrc_vad()

# Custom directory
lexicon_nrc_vad(dir = "data/")

# Deleting dataset
lexicon_nrc_vad(delete = TRUE)

# Returning filepath of data
lexicon_nrc_vad(return_path = TRUE)
}
}
\seealso{
Other lexicon: \code{\link{lexicon_afinn}},
  \code{\link{lexicon_bing}},
  \code{\link{lexicon_loughran}},
  \code{\link{lexicon_nrc_eil}}, \code{\link{lexicon_nrc}}
}
\concept{lexicon}
\keyword{datasets}
