% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finders.R
\name{findIntervals}
\alias{findIntervals}
\title{Find intervals within an IntervalTier.}
\usage{
findIntervals(tier, pattern = "*", from = -Inf, to = Inf,
  at = numeric(), ...)
}
\arguments{
\item{tier}{An \code{IntervalTier} object.}

\item{pattern}{A regular expression for matching interval labels.
Default is \code{'*'} so that the search finds all intervals within
\code{[from, to]}.}

\item{from}{A numeric, the earliest time from which to search for intervals.
Default is \code{-Inf} so that the search includes the start of \code{tier}.}

\item{to}{A numeric, the latest time to which to search for intervals.
Default is \code{Inf} so that the search includes the end of \code{tier}.}

\item{at}{A numeric, an exact time at which to find intervals.
Default is \code{numeric()} so that intervals are searched within
\code{[from, to]}.}

\item{...}{optional arguments passed to \code{grep}.}
}
\value{
A \code{data.frame} whose rows correspond to the intervals found
  according to the search criteria, and whose columns are:
  \code{$Index}, \code{$StartTime}, \code{$EndTime}, \code{$Label},
}
\description{
Find intervals according to various search criteria.
}
\details{
Default behavior of \code{findIntervals} is to search for intervals within
\code{[from, to]}. If the \code{at} argument is a non-empty numeric vector,
then this default behavior is overridden, and the \code{tier} is searched
only at the time given by \code{at}.
}
\seealso{
\code{\link{IntervalTier-class}}, \code{\link{grep}}
}

