% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dir.R
\name{read_dir}
\alias{read_dir}
\title{Read In Multiple Files From a Directory}
\usage{
read_dir(path, pattern = NULL, doc.col = "document",
  all.files = FALSE, recursive = FALSE, ignore.case = FALSE, ...)
}
\arguments{
\item{path}{Path to the directory.}

\item{pattern}{An optional regular expression. Only file names which match
the regular expression will be returned.}

\item{doc.col}{A string naming the document columns (i.e., file names sans
file extension).}

\item{all.files}{Logical.   If \code{FALSE}, only the names of visible files
are returned. If \code{TRUE}, all file names will be returned.}

\item{recursive}{Logical. Should the listing recurse into directories?}

\item{ignore.case}{logical.  If \code{TRUE} case in the \code{pattern} argument 
will be ignored.}

\item{\ldots}{Other arguments passed to read_document functions.}
}
\value{
Returns a \code{\link[base]{data.frame}} with file names as a document
column and content as a text column.
}
\description{
Read in multiple files from a directory and create a
\code{\link[base]{data.frame}}.
}
\examples{
read_dir(system.file("docs/Maas2011/pos", package = "textreadr"))
read_dir(system.file("docs/Maas2011", package = "textreadr"), recursive=TRUE)
}
