% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{duration}
\alias{duration}
\alias{duration.data.frame}
\alias{duration.default}
\alias{duration.numeric}
\alias{ends}
\alias{starts}
\title{Duration of Turns of Talk}
\usage{
duration(x, ...)

\method{duration}{default}(x, grouping.var = NULL, ...)

\method{duration}{data.frame}(x, text.var = TRUE,
  as.tibble = tibble_output(), ...)

\method{duration}{numeric}(x, ...)

starts(x, ...)

ends(x, ...)
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}} or character vector with a text
variable or a numeric vector.}

\item{grouping.var}{The grouping variables.  Default \code{NULL} generates
one word list for all text.  Also takes a single grouping variable or a list
of 1 or more grouping variables.}

\item{text.var}{The name of the text variable.  If \code{TRUE}
\code{duration} tries to detect the text column.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{Ignored.}
}
\value{
Returns a list of vectors of tokens or an expanded
\code{\link[data.table]{data.table}} with tokens split apart.
}
\description{
\code{duration} - Calculate duration (start and end times) for duration of turns
of talk measured in words.

\code{startss} - Calculate start times from a numeric vector.

\code{ends} - Calculate end times from a numeric vector.
}
\examples{
(x <- c(
    "Mr. Brown comes! He says hello. i give him coffee.",
    "I'll go at 5 p. m. eastern time.  Or somewhere in between!",
    "go there"
))
duration(x)
group <- c("A", "B", "A")
duration(x, group)

groups <- list(group1 = c("A", "B", "A"), group2 = c("red", "red", "green"))
duration(x, groups)

data(DATA)
duration(DATA)

## Larger data set
duration(hamlet)

## Integer values
x <- sample(1:10, 10)
duration(x)
starts(x)
ends(x)
}

