% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_spec.R
\name{step_categorical_column_with_vocabulary_list}
\alias{step_categorical_column_with_vocabulary_list}
\title{Creates a categorical column specification}
\usage{
step_categorical_column_with_vocabulary_list(
  spec,
  ...,
  vocabulary_list = NULL,
  dtype = NULL,
  default_value = -1L,
  num_oov_buckets = 0L
)
}
\arguments{
\item{spec}{A feature specification created with \code{\link[=feature_spec]{feature_spec()}}.}

\item{...}{Comma separated list of variable names to apply the step. \link{selectors} can also be used.}

\item{vocabulary_list}{An ordered iterable defining the vocabulary. Each
feature is mapped to the index of its value (if present) in vocabulary_list.
Must be castable to \code{dtype}. If \code{NULL} the vocabulary will be defined as
all unique values in the dataset provided when fitting the specification.}

\item{dtype}{The type of features. Only string and integer types are supported.
If \code{NULL}, it will be inferred from \code{vocabulary_list}.}

\item{default_value}{The integer ID value to return for out-of-vocabulary feature
values, defaults to \code{-1}. This can not be specified with a positive
num_oov_buckets.}

\item{num_oov_buckets}{Non-negative integer, the number of out-of-vocabulary buckets.
All out-of-vocabulary inputs will be assigned IDs in the range
\verb{[lenght(vocabulary_list), length(vocabulary_list)+num_oov_buckets)} based on a hash of
the input value. A positive num_oov_buckets can not be specified with
default_value.}
}
\value{
a \code{FeatureSpec} object.
}
\description{
Creates a categorical column specification
}
\examples{
\dontrun{
library(tfdatasets)
data(hearts)
hearts <- tensor_slices_dataset(hearts) \%>\% dataset_batch(32)

# use the formula interface
spec <- feature_spec(hearts, target ~ thal) \%>\%
  step_categorical_column_with_vocabulary_list(thal)

spec_fit <- fit(spec)
final_dataset <- hearts \%>\% dataset_use_spec(spec_fit)
}

}
\seealso{
\link{steps} for a complete list of allowed steps.

Other Feature Spec Functions: 
\code{\link{dataset_use_spec}()},
\code{\link{feature_spec}()},
\code{\link{fit.FeatureSpec}()},
\code{\link{step_bucketized_column}()},
\code{\link{step_categorical_column_with_hash_bucket}()},
\code{\link{step_categorical_column_with_identity}()},
\code{\link{step_categorical_column_with_vocabulary_file}()},
\code{\link{step_crossed_column}()},
\code{\link{step_embedding_column}()},
\code{\link{step_indicator_column}()},
\code{\link{step_numeric_column}()},
\code{\link{step_remove_column}()},
\code{\link{step_shared_embeddings_column}()},
\code{\link{steps}}
}
\concept{Feature Spec Functions}
