% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tprob.R
\name{tprob}
\alias{tprob}
\title{Return a table of T probabilities for all observed values}
\usage{
tprob(tferObj, x)
}
\arguments{
\item{tferObj}{an object of class \code{transfer}}

\item{x}{an optional set of values which specify the desired T-terms. 
E.g. x = c(0,1,2) would return T0, T1, and T2 and so on. Negative values of x will 
cause the function to stop. Values of x which exceed those observed will be assigned 
a value of zero. The return values will be returned in ascending order regardless of 
the order of x (although I suppose I could preserve the order if someone really cares).}
}
\value{
A table of T probabilities, giving the probability that x fragments 
were recovered given they were transferred and persisted according to the 
other inputs of the model.
}
\description{
Return a table of T probabilities for all observed values
}
\examples{
set.seed(123)
y = transfer()

tprob(y)
tprob(y, 55:120) ## max observed value is 113

}
