% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boosted_trees_estimators.R
\name{boosted_trees_estimators}
\alias{boosted_trees_estimators}
\alias{boosted_trees_regressor}
\alias{boosted_trees_classifier}
\title{Boosted Trees Estimator}
\usage{
boosted_trees_regressor(feature_columns, n_batches_per_layer,
  model_dir = NULL, label_dimension = 1L, weight_column = NULL,
  n_trees = 100L, max_depth = 6L, learning_rate = 0.1,
  l1_regularization = 0, l2_regularization = 0, tree_complexity = 0,
  min_node_weight = 0, config = NULL)

boosted_trees_classifier(feature_columns, n_batches_per_layer,
  model_dir = NULL, n_classes = 2L, weight_column = NULL,
  label_vocabulary = NULL, n_trees = 100L, max_depth = 6L,
  learning_rate = 0.1, l1_regularization = 0, l2_regularization = 0,
  tree_complexity = 0, min_node_weight = 0, config = NULL)
}
\arguments{
\item{feature_columns}{An \R list containing all of the feature columns used
by the model (typically, generated by \code{\link[=feature_columns]{feature_columns()}}).}

\item{n_batches_per_layer}{The number of batches to collect
statistics per layer.}

\item{model_dir}{Directory to save the model parameters, graph, and so on.
This can also be used to load checkpoints from the directory into a
estimator to continue training a previously saved model.}

\item{label_dimension}{Number of regression targets per example. This is the
size of the last dimension of the labels and logits \code{Tensor} objects
(typically, these have shape \code{[batch_size, label_dimension]}).}

\item{weight_column}{A string, or a numeric column created by
\code{\link[=column_numeric]{column_numeric()}} defining feature column representing weights. It is used
to down weight or boost examples during training. It will be multiplied by
the loss of the example. If it is a string, it is used as a key to fetch
weight tensor from the \code{features} argument. If it is a numeric column,
then the raw tensor is fetched by key \code{weight_column$key}, then
\code{weight_column$normalizer_fn} is applied on it to get weight tensor.}

\item{n_trees}{Number trees to be created.}

\item{max_depth}{Maximum depth of the tree to grow.}

\item{learning_rate}{Shrinkage parameter to be used when a tree
added to the model.}

\item{l1_regularization}{Regularization multiplier applied to the
absolute weights of the tree leafs.}

\item{l2_regularization}{Regularization multiplier applied to the
square weights of the tree leafs.}

\item{tree_complexity}{Regularization factor to penalize trees
with more leaves.}

\item{min_node_weight}{Minimum hessian a node must have for a
split to be considered. The value will be compared with
sum(leaf_hessian)/(batch_size * n_batches_per_layer).}

\item{config}{A run configuration created by \code{\link[=run_config]{run_config()}}, used to configure the runtime
settings.}

\item{n_classes}{The number of label classes.}

\item{label_vocabulary}{A list of strings represents possible label values.
If given, labels must be string type and have any value in
\code{label_vocabulary}. If it is not given, that means labels are already
encoded as integer or float within \code{[0, 1]} for \code{n_classes == 2} and
encoded as integer values in \code{{0, 1,..., n_classes -1}} for \code{n_classes > 2}. Also there will be errors if vocabulary is not provided and labels are
string.}
}
\description{
Construct a boosted trees estimator.
}
\seealso{
Other canned estimators: \code{\link{dnn_estimators}},
  \code{\link{dnn_linear_combined_estimators}},
  \code{\link{linear_estimators}}
}
\concept{canned estimators}
