% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_columns.R
\name{column_categorical_weighted}
\alias{column_categorical_weighted}
\title{Construct a Weighted Categorical Column}
\usage{
column_categorical_weighted(categorical_column, weight_feature_key,
  dtype = tf$float32)
}
\arguments{
\item{categorical_column}{A categorical column created by
\code{column_categorical_*()} functions.}

\item{weight_feature_key}{String key for weight values.}

\item{dtype}{Type of weights, such as \code{tf$float32}. Only float and integer
weights are supported.}
}
\value{
A categorical column composed of two sparse features: one
represents id, the other represents weight (value) of the id feature in
that example.
}
\description{
Use this when each of your sparse inputs has both an ID and a value. For
example, if you're representing text documents as a collection of word
frequencies, you can provide 2 parallel sparse input features ('terms' and
'frequencies' below).
}
\section{Raises}{

\itemize{
\item ValueError: if \code{dtype} is not convertible to float.
}
}

\seealso{
Other feature column constructors: \code{\link{column_bucketized}},
  \code{\link{column_categorical_with_hash_bucket}},
  \code{\link{column_categorical_with_identity}},
  \code{\link{column_categorical_with_vocabulary_file}},
  \code{\link{column_categorical_with_vocabulary_list}},
  \code{\link{column_crossed}},
  \code{\link{column_embedding}},
  \code{\link{column_numeric}}, \code{\link{input_layer}}
}
\concept{feature column constructors}
