% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_fn.R
\name{numpy_input_fn}
\alias{numpy_input_fn}
\title{Construct Input Function Containing Python Dictionaries of Numpy Arrays}
\usage{
numpy_input_fn(x, y = NULL, batch_size = 128, num_epochs = 1,
  shuffle = NULL, queue_capacity = 1000, num_threads = 1)
}
\arguments{
\item{x}{dict of numpy array object.}

\item{y}{numpy array object. \code{NULL} if absent.}

\item{batch_size}{Integer, size of batches to return.}

\item{num_epochs}{Integer, number of epochs to iterate over data. If \code{NULL}
will run forever.}

\item{shuffle}{Boolean, if \code{TRUE} shuffles the queue. Avoid shuffle at
prediction time.}

\item{queue_capacity}{Integer, size of queue to accumulate.}

\item{num_threads}{Integer, number of threads used for reading and
enqueueing. In order to have predicted and repeatable order of reading and
enqueueing, such as in prediction and evaluation mode, \code{num_threads} should
be 1. #'}
}
\description{
This returns a function outputting \code{features} and \code{target} based on the dict
of numpy arrays. The dict \code{features} has the same keys as the \code{x}.
}
\details{
Note that this function is still experimental and should only be used if
necessary, e.g. feed in data that's dictionary of numpy arrays.
}
\section{Raises}{
 ValueError: if the shape of \code{y} mismatches the shape of
values in \code{x} (i.e., values in \code{x} have same shape). TypeError: \code{x} is not
a dict or \code{shuffle} is not bool.
}

\seealso{
Other input functions: \code{\link{input_fn}}
}
\concept{input functions}
