% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hparams.R
\name{log_hparams_config}
\alias{log_hparams_config}
\alias{summary_hparams_config}
\title{Logs hyperparameters configuration}
\usage{
log_hparams_config(hparams, metrics, time_created_secs = get_wall_time())

summary_hparams_config(hparams, metrics, time_created_secs = get_wall_time())
}
\arguments{
\item{hparams}{A list of \code{hparams} objects as created by \code{\link[=hparams_hparam]{hparams_hparam()}}.}

\item{metrics}{A list of \code{metrics} objects as created by \code{\link[=hparams_metric]{hparams_metric()}}.
These metrics will be tracked by TensorBoard UI when displaying the
hyperparameter tuning table.}

\item{time_created_secs}{The time the experiment is created in seconds
since the UNIX epoch.}
}
\value{
Invisibly returns the HParam conffuration data as a \code{summary} object.
}
\description{
Logs the hyperaparameter configuration for a HyperParameter tuning experiment.
It allows you to define the domain for each hyperparameters and what are the
metrics that should be shown in the TensorBoard UI, along with configuring
their display name and descriptions.
}
\section{Functions}{
\itemize{
\item \code{summary_hparams_config()}: For advanced users only. Creates a hyperaparameter
configuration summary that can be logged with \code{\link[=log_event]{log_event()}}.

}}
\section{Recommendations}{


When loging hyperparameter tuning experiments, the log directory organization
is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{- root:
 - log_hparams_config(...)
 - run1:
   - log_hparams(...)
   - log_event(...)
 - run2:
   - log_hparams(...)
   - log_event(...)
}\if{html}{\out{</div>}}

Ie you should have a root logdir that will only contain the hyperaparameter
config log, as created with \code{\link[=log_hparams_config]{log_hparams_config()}}. Then each run in the
experiment will have it's own logdir as a child directory of the root logdir.
}

\seealso{
\code{\link[=log_hparams]{log_hparams()}}
}
