% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-functions.R
\name{mcmc_sample_annealed_importance_chain}
\alias{mcmc_sample_annealed_importance_chain}
\title{Runs annealed importance sampling (AIS) to estimate normalizing constants.}
\usage{
mcmc_sample_annealed_importance_chain(
  num_steps,
  proposal_log_prob_fn,
  target_log_prob_fn,
  current_state,
  make_kernel_fn,
  parallel_iterations = 10,
  name = NULL
)
}
\arguments{
\item{num_steps}{Integer number of Markov chain updates to run. More
iterations means more expense, but smoother annealing between q
and p, which in turn means exponentially lower variance for the
normalizing constant estimator.}

\item{proposal_log_prob_fn}{function that returns the log density of the
initial distribution.}

\item{target_log_prob_fn}{function which takes an argument like
\code{current_state} and returns its
(possibly unnormalized) log-density under the target distribution.}

\item{current_state}{\code{Tensor} or \code{list} of \code{Tensor}s representing the
current state(s) of the Markov chain(s). The first \code{r} dimensions index
independent chains, \code{r} = \code{tf$rank(target_log_prob_fn(current_state))}.}

\item{make_kernel_fn}{function which returns a \code{TransitionKernel}-like
object. Must take one argument representing the \code{TransitionKernel}'s
\code{target_log_prob_fn}. The \code{target_log_prob_fn} argument represents the
\code{TransitionKernel}'s target log distribution.  Note:
\code{sample_annealed_importance_chain} creates a new \code{target_log_prob_fn}
which is an interpolation between the supplied \code{target_log_prob_fn} and
\code{proposal_log_prob_fn}; it is this interpolated function which is used as
an argument to \code{make_kernel_fn}.}

\item{parallel_iterations}{The number of iterations allowed to run in parallel.
It must be a positive integer. See \code{tf$while_loop} for more details.}

\item{name}{string prefixed to Ops created by this function.
Default value: \code{NULL} (i.e., "sample_annealed_importance_chain").}
}
\value{
list of
\code{next_state} (\code{Tensor} or Python list of \code{Tensor}s representing the
state(s) of the Markov chain(s) at the final iteration. Has same shape as
input \code{current_state}),
\code{ais_weights} (Tensor with the estimated weight(s). Has shape matching
\code{target_log_prob_fn(current_state)}), and
\code{kernel_results} (\code{collections.namedtuple} of internal calculations used to
advance the chain).
}
\description{
This function uses an MCMC transition operator (e.g., Hamiltonian Monte Carlo)
to sample from a series of distributions that slowly interpolates between
an initial "proposal" distribution:
\code{exp(proposal_log_prob_fn(x) - proposal_log_normalizer)}
and the target distribution:
\code{exp(target_log_prob_fn(x) - target_log_normalizer)},
accumulating importance weights along the way. The product of these
importance weights gives an unbiased estimate of the ratio of the
normalizing constants of the initial distribution and the target
distribution:
\code{E[exp(ais_weights)] = exp(target_log_normalizer - proposal_log_normalizer)}.
}
\details{
Note: When running in graph mode, \code{proposal_log_prob_fn} and
\code{target_log_prob_fn} are called exactly three times (although this may be
reduced to two times in the future).
}
\seealso{
For an example how to use see \code{\link[=mcmc_sample_chain]{mcmc_sample_chain()}}.

Other mcmc_functions: 
\code{\link{mcmc_effective_sample_size}()},
\code{\link{mcmc_potential_scale_reduction}()},
\code{\link{mcmc_sample_chain}()},
\code{\link{mcmc_sample_halton_sequence}()}
}
\concept{mcmc_functions}
